<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExceptionBoundarySchool StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExceptionBoundarySchool
 * @subpackage Structs
 */
class ExceptionBoundarySchool extends AbstractStructBase
{
    /**
     * The ExceptionBoundaryGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExceptionBoundaryGuid;
    /**
     * The ExceptionBoundaryID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionBoundaryID;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * Constructor method for ExceptionBoundarySchool
     * @uses ExceptionBoundarySchool::setExceptionBoundaryGuid()
     * @uses ExceptionBoundarySchool::setExceptionBoundaryID()
     * @uses ExceptionBoundarySchool::setID()
     * @uses ExceptionBoundarySchool::setSchoolID()
     * @param string $exceptionBoundaryGuid
     * @param string $exceptionBoundaryID
     * @param \StructType\BPID $iD
     * @param string $schoolID
     */
    public function __construct($exceptionBoundaryGuid = null, $exceptionBoundaryID = null, \StructType\BPID $iD = null, $schoolID = null)
    {
        $this
            ->setExceptionBoundaryGuid($exceptionBoundaryGuid)
            ->setExceptionBoundaryID($exceptionBoundaryID)
            ->setID($iD)
            ->setSchoolID($schoolID);
    }
    /**
     * Get ExceptionBoundaryGuid value
     * @return string|null
     */
    public function getExceptionBoundaryGuid()
    {
        return $this->ExceptionBoundaryGuid;
    }
    /**
     * Set ExceptionBoundaryGuid value
     * @param string $exceptionBoundaryGuid
     * @return \StructType\ExceptionBoundarySchool
     */
    public function setExceptionBoundaryGuid($exceptionBoundaryGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exceptionBoundaryGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $exceptionBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($exceptionBoundaryGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exceptionBoundaryGuid) && !is_string($exceptionBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryGuid)), __LINE__);
        }
        $this->ExceptionBoundaryGuid = $exceptionBoundaryGuid;
        return $this;
    }
    /**
     * Get ExceptionBoundaryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionBoundaryID()
    {
        return isset($this->ExceptionBoundaryID) ? $this->ExceptionBoundaryID : null;
    }
    /**
     * Set ExceptionBoundaryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionBoundaryID
     * @return \StructType\ExceptionBoundarySchool
     */
    public function setExceptionBoundaryID($exceptionBoundaryID = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionBoundaryID) && !is_string($exceptionBoundaryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryID)), __LINE__);
        }
        if (is_null($exceptionBoundaryID) || (is_array($exceptionBoundaryID) && empty($exceptionBoundaryID))) {
            unset($this->ExceptionBoundaryID);
        } else {
            $this->ExceptionBoundaryID = $exceptionBoundaryID;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\ExceptionBoundarySchool
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get SchoolID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolID()
    {
        return isset($this->SchoolID) ? $this->SchoolID : null;
    }
    /**
     * Set SchoolID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolID
     * @return \StructType\ExceptionBoundarySchool
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        if (is_null($schoolID) || (is_array($schoolID) && empty($schoolID))) {
            unset($this->SchoolID);
        } else {
            $this->SchoolID = $schoolID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExceptionBoundarySchool
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
