<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExceptionBoundaryGrade StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExceptionBoundaryGrade
 * @subpackage Structs
 */
class ExceptionBoundaryGrade extends AbstractStructBase
{
    /**
     * The ExceptionBoundaryGradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExceptionBoundaryGradeGuid;
    /**
     * The ExceptionBoundaryGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExceptionBoundaryGuid;
    /**
     * The ExceptionBoundaryID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionBoundaryID;
    /**
     * The Grade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Grade;
    /**
     * The GradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeGuid;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The Regular
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Regular;
    /**
     * The SpecialEd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SpecialEd;
    /**
     * Constructor method for ExceptionBoundaryGrade
     * @uses ExceptionBoundaryGrade::setExceptionBoundaryGradeGuid()
     * @uses ExceptionBoundaryGrade::setExceptionBoundaryGuid()
     * @uses ExceptionBoundaryGrade::setExceptionBoundaryID()
     * @uses ExceptionBoundaryGrade::setGrade()
     * @uses ExceptionBoundaryGrade::setGradeGuid()
     * @uses ExceptionBoundaryGrade::setID()
     * @uses ExceptionBoundaryGrade::setRegular()
     * @uses ExceptionBoundaryGrade::setSpecialEd()
     * @param string $exceptionBoundaryGradeGuid
     * @param string $exceptionBoundaryGuid
     * @param string $exceptionBoundaryID
     * @param string $grade
     * @param string $gradeGuid
     * @param \StructType\BPID $iD
     * @param bool $regular
     * @param bool $specialEd
     */
    public function __construct($exceptionBoundaryGradeGuid = null, $exceptionBoundaryGuid = null, $exceptionBoundaryID = null, $grade = null, $gradeGuid = null, \StructType\BPID $iD = null, $regular = null, $specialEd = null)
    {
        $this
            ->setExceptionBoundaryGradeGuid($exceptionBoundaryGradeGuid)
            ->setExceptionBoundaryGuid($exceptionBoundaryGuid)
            ->setExceptionBoundaryID($exceptionBoundaryID)
            ->setGrade($grade)
            ->setGradeGuid($gradeGuid)
            ->setID($iD)
            ->setRegular($regular)
            ->setSpecialEd($specialEd);
    }
    /**
     * Get ExceptionBoundaryGradeGuid value
     * @return string|null
     */
    public function getExceptionBoundaryGradeGuid()
    {
        return $this->ExceptionBoundaryGradeGuid;
    }
    /**
     * Set ExceptionBoundaryGradeGuid value
     * @param string $exceptionBoundaryGradeGuid
     * @return \StructType\ExceptionBoundaryGrade
     */
    public function setExceptionBoundaryGradeGuid($exceptionBoundaryGradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exceptionBoundaryGradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $exceptionBoundaryGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($exceptionBoundaryGradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exceptionBoundaryGradeGuid) && !is_string($exceptionBoundaryGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryGradeGuid)), __LINE__);
        }
        $this->ExceptionBoundaryGradeGuid = $exceptionBoundaryGradeGuid;
        return $this;
    }
    /**
     * Get ExceptionBoundaryGuid value
     * @return string|null
     */
    public function getExceptionBoundaryGuid()
    {
        return $this->ExceptionBoundaryGuid;
    }
    /**
     * Set ExceptionBoundaryGuid value
     * @param string $exceptionBoundaryGuid
     * @return \StructType\ExceptionBoundaryGrade
     */
    public function setExceptionBoundaryGuid($exceptionBoundaryGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exceptionBoundaryGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $exceptionBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($exceptionBoundaryGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exceptionBoundaryGuid) && !is_string($exceptionBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryGuid)), __LINE__);
        }
        $this->ExceptionBoundaryGuid = $exceptionBoundaryGuid;
        return $this;
    }
    /**
     * Get ExceptionBoundaryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionBoundaryID()
    {
        return isset($this->ExceptionBoundaryID) ? $this->ExceptionBoundaryID : null;
    }
    /**
     * Set ExceptionBoundaryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionBoundaryID
     * @return \StructType\ExceptionBoundaryGrade
     */
    public function setExceptionBoundaryID($exceptionBoundaryID = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionBoundaryID) && !is_string($exceptionBoundaryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryID)), __LINE__);
        }
        if (is_null($exceptionBoundaryID) || (is_array($exceptionBoundaryID) && empty($exceptionBoundaryID))) {
            unset($this->ExceptionBoundaryID);
        } else {
            $this->ExceptionBoundaryID = $exceptionBoundaryID;
        }
        return $this;
    }
    /**
     * Get Grade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrade()
    {
        return isset($this->Grade) ? $this->Grade : null;
    }
    /**
     * Set Grade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grade
     * @return \StructType\ExceptionBoundaryGrade
     */
    public function setGrade($grade = null)
    {
        // validation for constraint: string
        if (!is_null($grade) && !is_string($grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grade)), __LINE__);
        }
        if (is_null($grade) || (is_array($grade) && empty($grade))) {
            unset($this->Grade);
        } else {
            $this->Grade = $grade;
        }
        return $this;
    }
    /**
     * Get GradeGuid value
     * @return string|null
     */
    public function getGradeGuid()
    {
        return $this->GradeGuid;
    }
    /**
     * Set GradeGuid value
     * @param string $gradeGuid
     * @return \StructType\ExceptionBoundaryGrade
     */
    public function setGradeGuid($gradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($gradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gradeGuid) && !is_string($gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gradeGuid)), __LINE__);
        }
        $this->GradeGuid = $gradeGuid;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\ExceptionBoundaryGrade
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Regular value
     * @return bool|null
     */
    public function getRegular()
    {
        return $this->Regular;
    }
    /**
     * Set Regular value
     * @param bool $regular
     * @return \StructType\ExceptionBoundaryGrade
     */
    public function setRegular($regular = null)
    {
        // validation for constraint: boolean
        if (!is_null($regular) && !is_bool($regular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($regular)), __LINE__);
        }
        $this->Regular = $regular;
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\ExceptionBoundaryGrade
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExceptionBoundaryGrade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
