<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExceptionBoundary StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExceptionBoundary
 * @subpackage Structs
 */
class ExceptionBoundary extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExceptionBoundaryGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExceptionBoundaryGuid;
    /**
     * The ExceptionBoundaryID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionBoundaryID;
    /**
     * The ExceptionBoundaryTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExceptionBoundaryTypeGuid;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The LatLongs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPosition
     */
    public $LatLongs;
    /**
     * The Protected
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protected;
    /**
     * The Public
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Public;
    /**
     * The Regular
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Regular;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The SIFGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SIFGuid;
    /**
     * The SpecialEd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SpecialEd;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionBoundaryType
     */
    public $Type;
    /**
     * Constructor method for ExceptionBoundary
     * @uses ExceptionBoundary::setActive()
     * @uses ExceptionBoundary::setDescription()
     * @uses ExceptionBoundary::setEffectiveDate()
     * @uses ExceptionBoundary::setExceptionBoundaryGuid()
     * @uses ExceptionBoundary::setExceptionBoundaryID()
     * @uses ExceptionBoundary::setExceptionBoundaryTypeGuid()
     * @uses ExceptionBoundary::setID()
     * @uses ExceptionBoundary::setLatLongs()
     * @uses ExceptionBoundary::setProtected()
     * @uses ExceptionBoundary::setPublic()
     * @uses ExceptionBoundary::setRegular()
     * @uses ExceptionBoundary::setRetireDate()
     * @uses ExceptionBoundary::setSIFGuid()
     * @uses ExceptionBoundary::setSpecialEd()
     * @uses ExceptionBoundary::setType()
     * @param bool $active
     * @param string $description
     * @param string $effectiveDate
     * @param string $exceptionBoundaryGuid
     * @param string $exceptionBoundaryID
     * @param string $exceptionBoundaryTypeGuid
     * @param \StructType\BPID $iD
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @param bool $protected
     * @param bool $public
     * @param bool $regular
     * @param string $retireDate
     * @param string $sIFGuid
     * @param bool $specialEd
     * @param \StructType\ExceptionBoundaryType $type
     */
    public function __construct($active = null, $description = null, $effectiveDate = null, $exceptionBoundaryGuid = null, $exceptionBoundaryID = null, $exceptionBoundaryTypeGuid = null, \StructType\BPID $iD = null, \ArrayType\ArrayOfPosition $latLongs = null, $protected = null, $public = null, $regular = null, $retireDate = null, $sIFGuid = null, $specialEd = null, \StructType\ExceptionBoundaryType $type = null)
    {
        $this
            ->setActive($active)
            ->setDescription($description)
            ->setEffectiveDate($effectiveDate)
            ->setExceptionBoundaryGuid($exceptionBoundaryGuid)
            ->setExceptionBoundaryID($exceptionBoundaryID)
            ->setExceptionBoundaryTypeGuid($exceptionBoundaryTypeGuid)
            ->setID($iD)
            ->setLatLongs($latLongs)
            ->setProtected($protected)
            ->setPublic($public)
            ->setRegular($regular)
            ->setRetireDate($retireDate)
            ->setSIFGuid($sIFGuid)
            ->setSpecialEd($specialEd)
            ->setType($type);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\ExceptionBoundary
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\ExceptionBoundary
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\ExceptionBoundary
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExceptionBoundaryGuid value
     * @return string|null
     */
    public function getExceptionBoundaryGuid()
    {
        return $this->ExceptionBoundaryGuid;
    }
    /**
     * Set ExceptionBoundaryGuid value
     * @param string $exceptionBoundaryGuid
     * @return \StructType\ExceptionBoundary
     */
    public function setExceptionBoundaryGuid($exceptionBoundaryGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exceptionBoundaryGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $exceptionBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($exceptionBoundaryGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exceptionBoundaryGuid) && !is_string($exceptionBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryGuid)), __LINE__);
        }
        $this->ExceptionBoundaryGuid = $exceptionBoundaryGuid;
        return $this;
    }
    /**
     * Get ExceptionBoundaryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionBoundaryID()
    {
        return isset($this->ExceptionBoundaryID) ? $this->ExceptionBoundaryID : null;
    }
    /**
     * Set ExceptionBoundaryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionBoundaryID
     * @return \StructType\ExceptionBoundary
     */
    public function setExceptionBoundaryID($exceptionBoundaryID = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionBoundaryID) && !is_string($exceptionBoundaryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryID)), __LINE__);
        }
        if (is_null($exceptionBoundaryID) || (is_array($exceptionBoundaryID) && empty($exceptionBoundaryID))) {
            unset($this->ExceptionBoundaryID);
        } else {
            $this->ExceptionBoundaryID = $exceptionBoundaryID;
        }
        return $this;
    }
    /**
     * Get ExceptionBoundaryTypeGuid value
     * @return string|null
     */
    public function getExceptionBoundaryTypeGuid()
    {
        return $this->ExceptionBoundaryTypeGuid;
    }
    /**
     * Set ExceptionBoundaryTypeGuid value
     * @param string $exceptionBoundaryTypeGuid
     * @return \StructType\ExceptionBoundary
     */
    public function setExceptionBoundaryTypeGuid($exceptionBoundaryTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exceptionBoundaryTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $exceptionBoundaryTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($exceptionBoundaryTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exceptionBoundaryTypeGuid) && !is_string($exceptionBoundaryTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryTypeGuid)), __LINE__);
        }
        $this->ExceptionBoundaryTypeGuid = $exceptionBoundaryTypeGuid;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\ExceptionBoundary
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get LatLongs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPosition|null
     */
    public function getLatLongs()
    {
        return isset($this->LatLongs) ? $this->LatLongs : null;
    }
    /**
     * Set LatLongs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @return \StructType\ExceptionBoundary
     */
    public function setLatLongs(\ArrayType\ArrayOfPosition $latLongs = null)
    {
        if (is_null($latLongs) || (is_array($latLongs) && empty($latLongs))) {
            unset($this->LatLongs);
        } else {
            $this->LatLongs = $latLongs;
        }
        return $this;
    }
    /**
     * Get Protected value
     * @return bool|null
     */
    public function getProtected()
    {
        return $this->Protected;
    }
    /**
     * Set Protected value
     * @param bool $protected
     * @return \StructType\ExceptionBoundary
     */
    public function setProtected($protected = null)
    {
        // validation for constraint: boolean
        if (!is_null($protected) && !is_bool($protected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protected)), __LINE__);
        }
        $this->Protected = $protected;
        return $this;
    }
    /**
     * Get Public value
     * @return bool|null
     */
    public function getPublic()
    {
        return $this->Public;
    }
    /**
     * Set Public value
     * @param bool $public
     * @return \StructType\ExceptionBoundary
     */
    public function setPublic($public = null)
    {
        // validation for constraint: boolean
        if (!is_null($public) && !is_bool($public)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($public)), __LINE__);
        }
        $this->Public = $public;
        return $this;
    }
    /**
     * Get Regular value
     * @return bool|null
     */
    public function getRegular()
    {
        return $this->Regular;
    }
    /**
     * Set Regular value
     * @param bool $regular
     * @return \StructType\ExceptionBoundary
     */
    public function setRegular($regular = null)
    {
        // validation for constraint: boolean
        if (!is_null($regular) && !is_bool($regular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($regular)), __LINE__);
        }
        $this->Regular = $regular;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\ExceptionBoundary
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get SIFGuid value
     * @return string|null
     */
    public function getSIFGuid()
    {
        return $this->SIFGuid;
    }
    /**
     * Set SIFGuid value
     * @param string $sIFGuid
     * @return \StructType\ExceptionBoundary
     */
    public function setSIFGuid($sIFGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sIFGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($sIFGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sIFGuid) && !is_string($sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIFGuid)), __LINE__);
        }
        $this->SIFGuid = $sIFGuid;
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\ExceptionBoundary
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionBoundaryType|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExceptionBoundaryType $type
     * @return \StructType\ExceptionBoundary
     */
    public function setType(\StructType\ExceptionBoundaryType $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExceptionBoundary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
