<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Enrollment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Enrollment
 * @subpackage Structs
 */
class Enrollment extends AbstractStructBase
{
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The Grade
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Grade;
    /**
     * The HomeRoom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomeRoom;
    /**
     * The Programs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Programs;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The SchoolName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolName;
    /**
     * The TravelMode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TravelMode;
    /**
     * The Eligibilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStudentEligibility
     */
    public $Eligibilities;
    /**
     * The EnrollmentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnrollmentType;
    /**
     * The EnrollmentGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrollmentGuid;
    /**
     * Constructor method for Enrollment
     * @uses Enrollment::setEffectiveDate()
     * @uses Enrollment::setGrade()
     * @uses Enrollment::setHomeRoom()
     * @uses Enrollment::setPrograms()
     * @uses Enrollment::setRetireDate()
     * @uses Enrollment::setSchoolID()
     * @uses Enrollment::setSchoolName()
     * @uses Enrollment::setTravelMode()
     * @uses Enrollment::setEligibilities()
     * @uses Enrollment::setEnrollmentType()
     * @uses Enrollment::setEnrollmentGuid()
     * @param string $effectiveDate
     * @param string $grade
     * @param string $homeRoom
     * @param \ArrayType\ArrayOfstring $programs
     * @param string $retireDate
     * @param string $schoolID
     * @param string $schoolName
     * @param string $travelMode
     * @param \ArrayType\ArrayOfStudentEligibility $eligibilities
     * @param string $enrollmentType
     * @param string $enrollmentGuid
     */
    public function __construct($effectiveDate = null, $grade = null, $homeRoom = null, \ArrayType\ArrayOfstring $programs = null, $retireDate = null, $schoolID = null, $schoolName = null, $travelMode = null, \ArrayType\ArrayOfStudentEligibility $eligibilities = null, $enrollmentType = null, $enrollmentGuid = null)
    {
        $this
            ->setEffectiveDate($effectiveDate)
            ->setGrade($grade)
            ->setHomeRoom($homeRoom)
            ->setPrograms($programs)
            ->setRetireDate($retireDate)
            ->setSchoolID($schoolID)
            ->setSchoolName($schoolName)
            ->setTravelMode($travelMode)
            ->setEligibilities($eligibilities)
            ->setEnrollmentType($enrollmentType)
            ->setEnrollmentGuid($enrollmentGuid);
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Enrollment
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get Grade value
     * @return string|null
     */
    public function getGrade()
    {
        return $this->Grade;
    }
    /**
     * Set Grade value
     * @param string $grade
     * @return \StructType\Enrollment
     */
    public function setGrade($grade = null)
    {
        // validation for constraint: string
        if (!is_null($grade) && !is_string($grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grade)), __LINE__);
        }
        $this->Grade = $grade;
        return $this;
    }
    /**
     * Get HomeRoom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomeRoom()
    {
        return isset($this->HomeRoom) ? $this->HomeRoom : null;
    }
    /**
     * Set HomeRoom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homeRoom
     * @return \StructType\Enrollment
     */
    public function setHomeRoom($homeRoom = null)
    {
        // validation for constraint: string
        if (!is_null($homeRoom) && !is_string($homeRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homeRoom)), __LINE__);
        }
        if (is_null($homeRoom) || (is_array($homeRoom) && empty($homeRoom))) {
            unset($this->HomeRoom);
        } else {
            $this->HomeRoom = $homeRoom;
        }
        return $this;
    }
    /**
     * Get Programs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getPrograms()
    {
        return isset($this->Programs) ? $this->Programs : null;
    }
    /**
     * Set Programs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $programs
     * @return \StructType\Enrollment
     */
    public function setPrograms(\ArrayType\ArrayOfstring $programs = null)
    {
        if (is_null($programs) || (is_array($programs) && empty($programs))) {
            unset($this->Programs);
        } else {
            $this->Programs = $programs;
        }
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\Enrollment
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get SchoolID value
     * @return string|null
     */
    public function getSchoolID()
    {
        return $this->SchoolID;
    }
    /**
     * Set SchoolID value
     * @param string $schoolID
     * @return \StructType\Enrollment
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        $this->SchoolID = $schoolID;
        return $this;
    }
    /**
     * Get SchoolName value
     * @return string|null
     */
    public function getSchoolName()
    {
        return $this->SchoolName;
    }
    /**
     * Set SchoolName value
     * @param string $schoolName
     * @return \StructType\Enrollment
     */
    public function setSchoolName($schoolName = null)
    {
        // validation for constraint: string
        if (!is_null($schoolName) && !is_string($schoolName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolName)), __LINE__);
        }
        $this->SchoolName = $schoolName;
        return $this;
    }
    /**
     * Get TravelMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTravelMode()
    {
        return isset($this->TravelMode) ? $this->TravelMode : null;
    }
    /**
     * Set TravelMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $travelMode
     * @return \StructType\Enrollment
     */
    public function setTravelMode($travelMode = null)
    {
        // validation for constraint: string
        if (!is_null($travelMode) && !is_string($travelMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelMode)), __LINE__);
        }
        if (is_null($travelMode) || (is_array($travelMode) && empty($travelMode))) {
            unset($this->TravelMode);
        } else {
            $this->TravelMode = $travelMode;
        }
        return $this;
    }
    /**
     * Get Eligibilities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStudentEligibility|null
     */
    public function getEligibilities()
    {
        return isset($this->Eligibilities) ? $this->Eligibilities : null;
    }
    /**
     * Set Eligibilities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStudentEligibility $eligibilities
     * @return \StructType\Enrollment
     */
    public function setEligibilities(\ArrayType\ArrayOfStudentEligibility $eligibilities = null)
    {
        if (is_null($eligibilities) || (is_array($eligibilities) && empty($eligibilities))) {
            unset($this->Eligibilities);
        } else {
            $this->Eligibilities = $eligibilities;
        }
        return $this;
    }
    /**
     * Get EnrollmentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollmentType()
    {
        return isset($this->EnrollmentType) ? $this->EnrollmentType : null;
    }
    /**
     * Set EnrollmentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrollmentType
     * @return \StructType\Enrollment
     */
    public function setEnrollmentType($enrollmentType = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentType) && !is_string($enrollmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollmentType)), __LINE__);
        }
        if (is_null($enrollmentType) || (is_array($enrollmentType) && empty($enrollmentType))) {
            unset($this->EnrollmentType);
        } else {
            $this->EnrollmentType = $enrollmentType;
        }
        return $this;
    }
    /**
     * Get EnrollmentGuid value
     * @return string|null
     */
    public function getEnrollmentGuid()
    {
        return $this->EnrollmentGuid;
    }
    /**
     * Set EnrollmentGuid value
     * @param string $enrollmentGuid
     * @return \StructType\Enrollment
     */
    public function setEnrollmentGuid($enrollmentGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enrollmentGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrollmentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($enrollmentGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enrollmentGuid) && !is_string($enrollmentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollmentGuid)), __LINE__);
        }
        $this->EnrollmentGuid = $enrollmentGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Enrollment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
