<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriverSchedule StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DriverSchedule
 * @subpackage Structs
 */
class DriverSchedule extends AbstractStructBase
{
    /**
     * The DriverGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DriverGuid;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndTime;
    /**
     * The Frequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Frequency
     */
    public $Frequency;
    /**
     * The RouteGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RouteGuid;
    /**
     * The RouteId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteId;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartTime;
    /**
     * The VehicleGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VehicleGuid;
    /**
     * Constructor method for DriverSchedule
     * @uses DriverSchedule::setDriverGuid()
     * @uses DriverSchedule::setEndTime()
     * @uses DriverSchedule::setFrequency()
     * @uses DriverSchedule::setRouteGuid()
     * @uses DriverSchedule::setRouteId()
     * @uses DriverSchedule::setStartTime()
     * @uses DriverSchedule::setVehicleGuid()
     * @param string $driverGuid
     * @param string $endTime
     * @param \StructType\Frequency $frequency
     * @param string $routeGuid
     * @param string $routeId
     * @param string $startTime
     * @param string $vehicleGuid
     */
    public function __construct($driverGuid = null, $endTime = null, \StructType\Frequency $frequency = null, $routeGuid = null, $routeId = null, $startTime = null, $vehicleGuid = null)
    {
        $this
            ->setDriverGuid($driverGuid)
            ->setEndTime($endTime)
            ->setFrequency($frequency)
            ->setRouteGuid($routeGuid)
            ->setRouteId($routeId)
            ->setStartTime($startTime)
            ->setVehicleGuid($vehicleGuid);
    }
    /**
     * Get DriverGuid value
     * @return string|null
     */
    public function getDriverGuid()
    {
        return $this->DriverGuid;
    }
    /**
     * Set DriverGuid value
     * @param string $driverGuid
     * @return \StructType\DriverSchedule
     */
    public function setDriverGuid($driverGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($driverGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $driverGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($driverGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($driverGuid) && !is_string($driverGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverGuid)), __LINE__);
        }
        $this->DriverGuid = $driverGuid;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\DriverSchedule
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get Frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Frequency|null
     */
    public function getFrequency()
    {
        return isset($this->Frequency) ? $this->Frequency : null;
    }
    /**
     * Set Frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Frequency $frequency
     * @return \StructType\DriverSchedule
     */
    public function setFrequency(\StructType\Frequency $frequency = null)
    {
        if (is_null($frequency) || (is_array($frequency) && empty($frequency))) {
            unset($this->Frequency);
        } else {
            $this->Frequency = $frequency;
        }
        return $this;
    }
    /**
     * Get RouteGuid value
     * @return string|null
     */
    public function getRouteGuid()
    {
        return $this->RouteGuid;
    }
    /**
     * Set RouteGuid value
     * @param string $routeGuid
     * @return \StructType\DriverSchedule
     */
    public function setRouteGuid($routeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($routeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $routeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($routeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeGuid) && !is_string($routeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeGuid)), __LINE__);
        }
        $this->RouteGuid = $routeGuid;
        return $this;
    }
    /**
     * Get RouteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteId()
    {
        return isset($this->RouteId) ? $this->RouteId : null;
    }
    /**
     * Set RouteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeId
     * @return \StructType\DriverSchedule
     */
    public function setRouteId($routeId = null)
    {
        // validation for constraint: string
        if (!is_null($routeId) && !is_string($routeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeId)), __LINE__);
        }
        if (is_null($routeId) || (is_array($routeId) && empty($routeId))) {
            unset($this->RouteId);
        } else {
            $this->RouteId = $routeId;
        }
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\DriverSchedule
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get VehicleGuid value
     * @return string|null
     */
    public function getVehicleGuid()
    {
        return $this->VehicleGuid;
    }
    /**
     * Set VehicleGuid value
     * @param string $vehicleGuid
     * @return \StructType\DriverSchedule
     */
    public function setVehicleGuid($vehicleGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vehicleGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($vehicleGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleGuid) && !is_string($vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleGuid)), __LINE__);
        }
        $this->VehicleGuid = $vehicleGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DriverSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
