<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for District StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:District
 * @subpackage Structs
 */
class District extends AbstractStructBase
{
    /**
     * The DistrictID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DistrictID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The BPID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $BPID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Director
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Director;
    /**
     * The DistrictGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DistrictGuid;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The LatLongs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPosition
     */
    public $LatLongs;
    /**
     * The MailingAddress1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingAddress1;
    /**
     * The MailingAddress2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingAddress2;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The Protected
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protected;
    /**
     * The Public
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Public;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The SIFGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SIFGuid;
    /**
     * The Webpage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Webpage;
    /**
     * Constructor method for District
     * @uses District::setDistrictID()
     * @uses District::setName()
     * @uses District::setActive()
     * @uses District::setBPID()
     * @uses District::setDescription()
     * @uses District::setDirector()
     * @uses District::setDistrictGuid()
     * @uses District::setEffectiveDate()
     * @uses District::setLatLongs()
     * @uses District::setMailingAddress1()
     * @uses District::setMailingAddress2()
     * @uses District::setPhone()
     * @uses District::setProtected()
     * @uses District::setPublic()
     * @uses District::setRetireDate()
     * @uses District::setSIFGuid()
     * @uses District::setWebpage()
     * @param string $districtID
     * @param string $name
     * @param bool $active
     * @param \StructType\BPID $bPID
     * @param string $description
     * @param string $director
     * @param string $districtGuid
     * @param string $effectiveDate
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @param string $mailingAddress1
     * @param string $mailingAddress2
     * @param string $phone
     * @param bool $protected
     * @param bool $public
     * @param string $retireDate
     * @param string $sIFGuid
     * @param string $webpage
     */
    public function __construct($districtID = null, $name = null, $active = null, \StructType\BPID $bPID = null, $description = null, $director = null, $districtGuid = null, $effectiveDate = null, \ArrayType\ArrayOfPosition $latLongs = null, $mailingAddress1 = null, $mailingAddress2 = null, $phone = null, $protected = null, $public = null, $retireDate = null, $sIFGuid = null, $webpage = null)
    {
        $this
            ->setDistrictID($districtID)
            ->setName($name)
            ->setActive($active)
            ->setBPID($bPID)
            ->setDescription($description)
            ->setDirector($director)
            ->setDistrictGuid($districtGuid)
            ->setEffectiveDate($effectiveDate)
            ->setLatLongs($latLongs)
            ->setMailingAddress1($mailingAddress1)
            ->setMailingAddress2($mailingAddress2)
            ->setPhone($phone)
            ->setProtected($protected)
            ->setPublic($public)
            ->setRetireDate($retireDate)
            ->setSIFGuid($sIFGuid)
            ->setWebpage($webpage);
    }
    /**
     * Get DistrictID value
     * @return string|null
     */
    public function getDistrictID()
    {
        return $this->DistrictID;
    }
    /**
     * Set DistrictID value
     * @param string $districtID
     * @return \StructType\District
     */
    public function setDistrictID($districtID = null)
    {
        // validation for constraint: string
        if (!is_null($districtID) && !is_string($districtID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($districtID)), __LINE__);
        }
        $this->DistrictID = $districtID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\District
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\District
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get BPID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getBPID()
    {
        return isset($this->BPID) ? $this->BPID : null;
    }
    /**
     * Set BPID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $bPID
     * @return \StructType\District
     */
    public function setBPID(\StructType\BPID $bPID = null)
    {
        if (is_null($bPID) || (is_array($bPID) && empty($bPID))) {
            unset($this->BPID);
        } else {
            $this->BPID = $bPID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\District
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Director value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirector()
    {
        return isset($this->Director) ? $this->Director : null;
    }
    /**
     * Set Director value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $director
     * @return \StructType\District
     */
    public function setDirector($director = null)
    {
        // validation for constraint: string
        if (!is_null($director) && !is_string($director)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($director)), __LINE__);
        }
        if (is_null($director) || (is_array($director) && empty($director))) {
            unset($this->Director);
        } else {
            $this->Director = $director;
        }
        return $this;
    }
    /**
     * Get DistrictGuid value
     * @return string|null
     */
    public function getDistrictGuid()
    {
        return $this->DistrictGuid;
    }
    /**
     * Set DistrictGuid value
     * @param string $districtGuid
     * @return \StructType\District
     */
    public function setDistrictGuid($districtGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($districtGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $districtGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($districtGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($districtGuid) && !is_string($districtGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($districtGuid)), __LINE__);
        }
        $this->DistrictGuid = $districtGuid;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\District
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get LatLongs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPosition|null
     */
    public function getLatLongs()
    {
        return isset($this->LatLongs) ? $this->LatLongs : null;
    }
    /**
     * Set LatLongs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPosition $latLongs
     * @return \StructType\District
     */
    public function setLatLongs(\ArrayType\ArrayOfPosition $latLongs = null)
    {
        if (is_null($latLongs) || (is_array($latLongs) && empty($latLongs))) {
            unset($this->LatLongs);
        } else {
            $this->LatLongs = $latLongs;
        }
        return $this;
    }
    /**
     * Get MailingAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingAddress1()
    {
        return isset($this->MailingAddress1) ? $this->MailingAddress1 : null;
    }
    /**
     * Set MailingAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingAddress1
     * @return \StructType\District
     */
    public function setMailingAddress1($mailingAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($mailingAddress1) && !is_string($mailingAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingAddress1)), __LINE__);
        }
        if (is_null($mailingAddress1) || (is_array($mailingAddress1) && empty($mailingAddress1))) {
            unset($this->MailingAddress1);
        } else {
            $this->MailingAddress1 = $mailingAddress1;
        }
        return $this;
    }
    /**
     * Get MailingAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingAddress2()
    {
        return isset($this->MailingAddress2) ? $this->MailingAddress2 : null;
    }
    /**
     * Set MailingAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingAddress2
     * @return \StructType\District
     */
    public function setMailingAddress2($mailingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($mailingAddress2) && !is_string($mailingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingAddress2)), __LINE__);
        }
        if (is_null($mailingAddress2) || (is_array($mailingAddress2) && empty($mailingAddress2))) {
            unset($this->MailingAddress2);
        } else {
            $this->MailingAddress2 = $mailingAddress2;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \StructType\District
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get Protected value
     * @return bool|null
     */
    public function getProtected()
    {
        return $this->Protected;
    }
    /**
     * Set Protected value
     * @param bool $protected
     * @return \StructType\District
     */
    public function setProtected($protected = null)
    {
        // validation for constraint: boolean
        if (!is_null($protected) && !is_bool($protected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protected)), __LINE__);
        }
        $this->Protected = $protected;
        return $this;
    }
    /**
     * Get Public value
     * @return bool|null
     */
    public function getPublic()
    {
        return $this->Public;
    }
    /**
     * Set Public value
     * @param bool $public
     * @return \StructType\District
     */
    public function setPublic($public = null)
    {
        // validation for constraint: boolean
        if (!is_null($public) && !is_bool($public)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($public)), __LINE__);
        }
        $this->Public = $public;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\District
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get SIFGuid value
     * @return string|null
     */
    public function getSIFGuid()
    {
        return $this->SIFGuid;
    }
    /**
     * Set SIFGuid value
     * @param string $sIFGuid
     * @return \StructType\District
     */
    public function setSIFGuid($sIFGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sIFGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($sIFGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sIFGuid) && !is_string($sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIFGuid)), __LINE__);
        }
        $this->SIFGuid = $sIFGuid;
        return $this;
    }
    /**
     * Get Webpage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebpage()
    {
        return isset($this->Webpage) ? $this->Webpage : null;
    }
    /**
     * Set Webpage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webpage
     * @return \StructType\District
     */
    public function setWebpage($webpage = null)
    {
        // validation for constraint: string
        if (!is_null($webpage) && !is_string($webpage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($webpage)), __LINE__);
        }
        if (is_null($webpage) || (is_array($webpage) && empty($webpage))) {
            unset($this->Webpage);
        } else {
            $this->Webpage = $webpage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\District
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
