<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Depot StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Depot
 * @subpackage Structs
 */
class Depot extends AbstractStructBase
{
    /**
     * The DepotID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DepotID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The LatLong
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Position
     */
    public $LatLong;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Location;
    /**
     * The OperatorID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatorID;
    /**
     * Constructor method for Depot
     * @uses Depot::setDepotID()
     * @uses Depot::setDescription()
     * @uses Depot::setLatLong()
     * @uses Depot::setLocation()
     * @uses Depot::setOperatorID()
     * @param string $depotID
     * @param string $description
     * @param \StructType\Position $latLong
     * @param string $location
     * @param string $operatorID
     */
    public function __construct($depotID = null, $description = null, \StructType\Position $latLong = null, $location = null, $operatorID = null)
    {
        $this
            ->setDepotID($depotID)
            ->setDescription($description)
            ->setLatLong($latLong)
            ->setLocation($location)
            ->setOperatorID($operatorID);
    }
    /**
     * Get DepotID value
     * @return string|null
     */
    public function getDepotID()
    {
        return $this->DepotID;
    }
    /**
     * Set DepotID value
     * @param string $depotID
     * @return \StructType\Depot
     */
    public function setDepotID($depotID = null)
    {
        // validation for constraint: string
        if (!is_null($depotID) && !is_string($depotID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depotID)), __LINE__);
        }
        $this->DepotID = $depotID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Depot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get LatLong value
     * @return \StructType\Position|null
     */
    public function getLatLong()
    {
        return $this->LatLong;
    }
    /**
     * Set LatLong value
     * @param \StructType\Position $latLong
     * @return \StructType\Depot
     */
    public function setLatLong(\StructType\Position $latLong = null)
    {
        $this->LatLong = $latLong;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\Depot
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get OperatorID value
     * @return string|null
     */
    public function getOperatorID()
    {
        return $this->OperatorID;
    }
    /**
     * Set OperatorID value
     * @param string $operatorID
     * @return \StructType\Depot
     */
    public function setOperatorID($operatorID = null)
    {
        // validation for constraint: string
        if (!is_null($operatorID) && !is_string($operatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorID)), __LINE__);
        }
        $this->OperatorID = $operatorID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Depot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
