<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteGPSRouteVehicle.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DeleteGPSRouteVehicle.Options
 * @subpackage Structs
 */
class DeleteGPSRouteVehicle_Options extends WebServiceRequestOptions
{
    /**
     * The RouteVehicleGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RouteVehicleGuid;
    /**
     * Constructor method for DeleteGPSRouteVehicle.Options
     * @uses DeleteGPSRouteVehicle_Options::setRouteVehicleGuid()
     * @param string $routeVehicleGuid
     */
    public function __construct($routeVehicleGuid = null)
    {
        $this
            ->setRouteVehicleGuid($routeVehicleGuid);
    }
    /**
     * Get RouteVehicleGuid value
     * @return string|null
     */
    public function getRouteVehicleGuid()
    {
        return $this->RouteVehicleGuid;
    }
    /**
     * Set RouteVehicleGuid value
     * @param string $routeVehicleGuid
     * @return \StructType\DeleteGPSRouteVehicle_Options
     */
    public function setRouteVehicleGuid($routeVehicleGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($routeVehicleGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $routeVehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($routeVehicleGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeVehicleGuid) && !is_string($routeVehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeVehicleGuid)), __LINE__);
        }
        $this->RouteVehicleGuid = $routeVehicleGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteGPSRouteVehicle_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
