<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Component StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Component
 * @subpackage Structs
 */
class Component extends AbstractStructBase
{
    /**
     * The ComponentID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ComponentID;
    /**
     * The ComponentType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ComponentType;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ModifiedDate
     * @var string
     */
    public $ModifiedDate;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * The VehicleGuid
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VehicleGuid;
    /**
     * The VehicleID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $VehicleID;
    /**
     * Constructor method for Component
     * @uses Component::setComponentID()
     * @uses Component::setComponentType()
     * @uses Component::setCreatedDate()
     * @uses Component::setDescription()
     * @uses Component::setModifiedDate()
     * @uses Component::setOrder()
     * @uses Component::setRouteID()
     * @uses Component::setVehicleGuid()
     * @uses Component::setVehicleID()
     * @param string $componentID
     * @param string $componentType
     * @param string $createdDate
     * @param string $description
     * @param string $modifiedDate
     * @param int $order
     * @param string $routeID
     * @param string $vehicleGuid
     * @param string $vehicleID
     */
    public function __construct($componentID = null, $componentType = null, $createdDate = null, $description = null, $modifiedDate = null, $order = null, $routeID = null, $vehicleGuid = null, $vehicleID = null)
    {
        $this
            ->setComponentID($componentID)
            ->setComponentType($componentType)
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setModifiedDate($modifiedDate)
            ->setOrder($order)
            ->setRouteID($routeID)
            ->setVehicleGuid($vehicleGuid)
            ->setVehicleID($vehicleID);
    }
    /**
     * Get ComponentID value
     * @return string|null
     */
    public function getComponentID()
    {
        return $this->ComponentID;
    }
    /**
     * Set ComponentID value
     * @param string $componentID
     * @return \StructType\Component
     */
    public function setComponentID($componentID = null)
    {
        // validation for constraint: string
        if (!is_null($componentID) && !is_string($componentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($componentID)), __LINE__);
        }
        $this->ComponentID = $componentID;
        return $this;
    }
    /**
     * Get ComponentType value
     * @return string|null
     */
    public function getComponentType()
    {
        return $this->ComponentType;
    }
    /**
     * Set ComponentType value
     * @param string $componentType
     * @return \StructType\Component
     */
    public function setComponentType($componentType = null)
    {
        // validation for constraint: string
        if (!is_null($componentType) && !is_string($componentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($componentType)), __LINE__);
        }
        $this->ComponentType = $componentType;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Component
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Component
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string|null
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\Component
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\Component
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get RouteID value
     * @return string|null
     */
    public function getRouteID()
    {
        return $this->RouteID;
    }
    /**
     * Set RouteID value
     * @param string $routeID
     * @return \StructType\Component
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        $this->RouteID = $routeID;
        return $this;
    }
    /**
     * Get VehicleGuid value
     * @return string|null
     */
    public function getVehicleGuid()
    {
        return $this->VehicleGuid;
    }
    /**
     * Set VehicleGuid value
     * @param string $vehicleGuid
     * @return \StructType\Component
     */
    public function setVehicleGuid($vehicleGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vehicleGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($vehicleGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleGuid) && !is_string($vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleGuid)), __LINE__);
        }
        $this->VehicleGuid = $vehicleGuid;
        return $this;
    }
    /**
     * Get VehicleID value
     * @return string|null
     */
    public function getVehicleID()
    {
        return $this->VehicleID;
    }
    /**
     * Set VehicleID value
     * @param string $vehicleID
     * @return \StructType\Component
     */
    public function setVehicleID($vehicleID = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleID) && !is_string($vehicleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleID)), __LINE__);
        }
        $this->VehicleID = $vehicleID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Component
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
