<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusStopStudent StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BusStopStudent
 * @subpackage Structs
 */
class BusStopStudent extends AbstractStructBase
{
    /**
     * The Distance
     * @var float
     */
    public $Distance;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The RetireDate
     * @var string
     */
    public $RetireDate;
    /**
     * The Schedule
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Schedule;
    /**
     * The AddressGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressGuid;
    /**
     * The EnrollmentGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrollmentGuid;
    /**
     * The AddressTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressTypeGuid;
    /**
     * Constructor method for BusStopStudent
     * @uses BusStopStudent::setDistance()
     * @uses BusStopStudent::setEffectiveDate()
     * @uses BusStopStudent::setRetireDate()
     * @uses BusStopStudent::setSchedule()
     * @uses BusStopStudent::setAddressGuid()
     * @uses BusStopStudent::setEnrollmentGuid()
     * @uses BusStopStudent::setAddressTypeGuid()
     * @param float $distance
     * @param string $effectiveDate
     * @param string $retireDate
     * @param string $schedule
     * @param string $addressGuid
     * @param string $enrollmentGuid
     * @param string $addressTypeGuid
     */
    public function __construct($distance = null, $effectiveDate = null, $retireDate = null, $schedule = null, $addressGuid = null, $enrollmentGuid = null, $addressTypeGuid = null)
    {
        $this
            ->setDistance($distance)
            ->setEffectiveDate($effectiveDate)
            ->setRetireDate($retireDate)
            ->setSchedule($schedule)
            ->setAddressGuid($addressGuid)
            ->setEnrollmentGuid($enrollmentGuid)
            ->setAddressTypeGuid($addressTypeGuid);
    }
    /**
     * Get Distance value
     * @return float|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \StructType\BusStopStudent
     */
    public function setDistance($distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\BusStopStudent
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\BusStopStudent
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get Schedule value
     * @return string|null
     */
    public function getSchedule()
    {
        return $this->Schedule;
    }
    /**
     * Set Schedule value
     * @param string $schedule
     * @return \StructType\BusStopStudent
     */
    public function setSchedule($schedule = null)
    {
        // validation for constraint: string
        if (!is_null($schedule) && !is_string($schedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schedule)), __LINE__);
        }
        $this->Schedule = $schedule;
        return $this;
    }
    /**
     * Get AddressGuid value
     * @return string|null
     */
    public function getAddressGuid()
    {
        return $this->AddressGuid;
    }
    /**
     * Set AddressGuid value
     * @param string $addressGuid
     * @return \StructType\BusStopStudent
     */
    public function setAddressGuid($addressGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($addressGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressGuid) && !is_string($addressGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressGuid)), __LINE__);
        }
        $this->AddressGuid = $addressGuid;
        return $this;
    }
    /**
     * Get EnrollmentGuid value
     * @return string|null
     */
    public function getEnrollmentGuid()
    {
        return $this->EnrollmentGuid;
    }
    /**
     * Set EnrollmentGuid value
     * @param string $enrollmentGuid
     * @return \StructType\BusStopStudent
     */
    public function setEnrollmentGuid($enrollmentGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enrollmentGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrollmentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($enrollmentGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enrollmentGuid) && !is_string($enrollmentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollmentGuid)), __LINE__);
        }
        $this->EnrollmentGuid = $enrollmentGuid;
        return $this;
    }
    /**
     * Get AddressTypeGuid value
     * @return string|null
     */
    public function getAddressTypeGuid()
    {
        return $this->AddressTypeGuid;
    }
    /**
     * Set AddressTypeGuid value
     * @param string $addressTypeGuid
     * @return \StructType\BusStopStudent
     */
    public function setAddressTypeGuid($addressTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($addressTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressTypeGuid) && !is_string($addressTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressTypeGuid)), __LINE__);
        }
        $this->AddressTypeGuid = $addressTypeGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusStopStudent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
