<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BPSenderFaultDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BPSenderFaultDetail
 * @subpackage Structs
 */
class BPSenderFaultDetail extends AbstractStructBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The FailedBodyElements
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $FailedBodyElements;
    /**
     * Constructor method for BPSenderFaultDetail
     * @uses BPSenderFaultDetail::setMessage()
     * @uses BPSenderFaultDetail::setDescription()
     * @uses BPSenderFaultDetail::setFailedBodyElements()
     * @param string $message
     * @param string $description
     * @param \ArrayType\ArrayOfstring $failedBodyElements
     */
    public function __construct($message = null, $description = null, \ArrayType\ArrayOfstring $failedBodyElements = null)
    {
        $this
            ->setMessage($message)
            ->setDescription($description)
            ->setFailedBodyElements($failedBodyElements);
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\BPSenderFaultDetail
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\BPSenderFaultDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FailedBodyElements value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFailedBodyElements()
    {
        return $this->FailedBodyElements;
    }
    /**
     * Set FailedBodyElements value
     * @param \ArrayType\ArrayOfstring $failedBodyElements
     * @return \StructType\BPSenderFaultDetail
     */
    public function setFailedBodyElements(\ArrayType\ArrayOfstring $failedBodyElements = null)
    {
        $this->FailedBodyElements = $failedBodyElements;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BPSenderFaultDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
