<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BPID StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BPID
 * @subpackage Structs
 */
class BPID extends AbstractStructBase
{
    /**
     * The LayerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LayerId;
    /**
     * The ObjId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ObjId;
    /**
     * The ObjType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ObjType;
    /**
     * The SeqNum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeqNum;
    /**
     * Constructor method for BPID
     * @uses BPID::setLayerId()
     * @uses BPID::setObjId()
     * @uses BPID::setObjType()
     * @uses BPID::setSeqNum()
     * @param int $layerId
     * @param int $objId
     * @param int $objType
     * @param int $seqNum
     */
    public function __construct($layerId = null, $objId = null, $objType = null, $seqNum = null)
    {
        $this
            ->setLayerId($layerId)
            ->setObjId($objId)
            ->setObjType($objType)
            ->setSeqNum($seqNum);
    }
    /**
     * Get LayerId value
     * @return int|null
     */
    public function getLayerId()
    {
        return $this->LayerId;
    }
    /**
     * Set LayerId value
     * @param int $layerId
     * @return \StructType\BPID
     */
    public function setLayerId($layerId = null)
    {
        // validation for constraint: int
        if (!is_null($layerId) && !is_numeric($layerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($layerId)), __LINE__);
        }
        $this->LayerId = $layerId;
        return $this;
    }
    /**
     * Get ObjId value
     * @return int|null
     */
    public function getObjId()
    {
        return $this->ObjId;
    }
    /**
     * Set ObjId value
     * @param int $objId
     * @return \StructType\BPID
     */
    public function setObjId($objId = null)
    {
        // validation for constraint: int
        if (!is_null($objId) && !is_numeric($objId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($objId)), __LINE__);
        }
        $this->ObjId = $objId;
        return $this;
    }
    /**
     * Get ObjType value
     * @return int|null
     */
    public function getObjType()
    {
        return $this->ObjType;
    }
    /**
     * Set ObjType value
     * @param int $objType
     * @return \StructType\BPID
     */
    public function setObjType($objType = null)
    {
        // validation for constraint: int
        if (!is_null($objType) && !is_numeric($objType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($objType)), __LINE__);
        }
        $this->ObjType = $objType;
        return $this;
    }
    /**
     * Get SeqNum value
     * @return int|null
     */
    public function getSeqNum()
    {
        return $this->SeqNum;
    }
    /**
     * Set SeqNum value
     * @param int $seqNum
     * @return \StructType\BPID
     */
    public function setSeqNum($seqNum = null)
    {
        // validation for constraint: int
        if (!is_null($seqNum) && !is_numeric($seqNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seqNum)), __LINE__);
        }
        $this->SeqNum = $seqNum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BPID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
