<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateStudentInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthenticateStudentInfo
 * @subpackage Structs
 */
class AuthenticateStudentInfo extends AbstractStructBase
{
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The Grade
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Grade;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The PIN
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PIN;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The StreetNum
     * @var int
     */
    public $StreetNum;
    /**
     * The StudentID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StudentID;
    /**
     * Constructor method for AuthenticateStudentInfo
     * @uses AuthenticateStudentInfo::setBirthDate()
     * @uses AuthenticateStudentInfo::setGrade()
     * @uses AuthenticateStudentInfo::setLastName()
     * @uses AuthenticateStudentInfo::setPIN()
     * @uses AuthenticateStudentInfo::setSchoolID()
     * @uses AuthenticateStudentInfo::setStreetNum()
     * @uses AuthenticateStudentInfo::setStudentID()
     * @param string $birthDate
     * @param string $grade
     * @param string $lastName
     * @param string $pIN
     * @param string $schoolID
     * @param int $streetNum
     * @param string $studentID
     */
    public function __construct($birthDate = null, $grade = null, $lastName = null, $pIN = null, $schoolID = null, $streetNum = null, $studentID = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setGrade($grade)
            ->setLastName($lastName)
            ->setPIN($pIN)
            ->setSchoolID($schoolID)
            ->setStreetNum($streetNum)
            ->setStudentID($studentID);
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\AuthenticateStudentInfo
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Grade value
     * @return string|null
     */
    public function getGrade()
    {
        return $this->Grade;
    }
    /**
     * Set Grade value
     * @param string $grade
     * @return \StructType\AuthenticateStudentInfo
     */
    public function setGrade($grade = null)
    {
        // validation for constraint: pattern
        if (is_scalar($grade) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($grade, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($grade) && !is_string($grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grade)), __LINE__);
        }
        $this->Grade = $grade;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\AuthenticateStudentInfo
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \StructType\AuthenticateStudentInfo
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get SchoolID value
     * @return string|null
     */
    public function getSchoolID()
    {
        return $this->SchoolID;
    }
    /**
     * Set SchoolID value
     * @param string $schoolID
     * @return \StructType\AuthenticateStudentInfo
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        $this->SchoolID = $schoolID;
        return $this;
    }
    /**
     * Get StreetNum value
     * @return int|null
     */
    public function getStreetNum()
    {
        return $this->StreetNum;
    }
    /**
     * Set StreetNum value
     * @param int $streetNum
     * @return \StructType\AuthenticateStudentInfo
     */
    public function setStreetNum($streetNum = null)
    {
        // validation for constraint: int
        if (!is_null($streetNum) && !is_numeric($streetNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($streetNum)), __LINE__);
        }
        $this->StreetNum = $streetNum;
        return $this;
    }
    /**
     * Get StudentID value
     * @return string|null
     */
    public function getStudentID()
    {
        return $this->StudentID;
    }
    /**
     * Set StudentID value
     * @param string $studentID
     * @return \StructType\AuthenticateStudentInfo
     */
    public function setStudentID($studentID = null)
    {
        // validation for constraint: string
        if (!is_null($studentID) && !is_string($studentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentID)), __LINE__);
        }
        $this->StudentID = $studentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthenticateStudentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
