<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Address
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The Apartment
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Apartment;
    /**
     * The Municipality
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Municipality;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The StreetName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StreetName;
    /**
     * The StreetNumber
     * @var int
     */
    public $StreetNumber;
    /**
     * Constructor method for Address
     * @uses Address::setApartment()
     * @uses Address::setMunicipality()
     * @uses Address::setPostalCode()
     * @uses Address::setStreetName()
     * @uses Address::setStreetNumber()
     * @param string $apartment
     * @param string $municipality
     * @param string $postalCode
     * @param string $streetName
     * @param int $streetNumber
     */
    public function __construct($apartment = null, $municipality = null, $postalCode = null, $streetName = null, $streetNumber = null)
    {
        $this
            ->setApartment($apartment)
            ->setMunicipality($municipality)
            ->setPostalCode($postalCode)
            ->setStreetName($streetName)
            ->setStreetNumber($streetNumber);
    }
    /**
     * Get Apartment value
     * @return string|null
     */
    public function getApartment()
    {
        return $this->Apartment;
    }
    /**
     * Set Apartment value
     * @param string $apartment
     * @return \StructType\Address
     */
    public function setApartment($apartment = null)
    {
        // validation for constraint: string
        if (!is_null($apartment) && !is_string($apartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apartment)), __LINE__);
        }
        $this->Apartment = $apartment;
        return $this;
    }
    /**
     * Get Municipality value
     * @return string|null
     */
    public function getMunicipality()
    {
        return $this->Municipality;
    }
    /**
     * Set Municipality value
     * @param string $municipality
     * @return \StructType\Address
     */
    public function setMunicipality($municipality = null)
    {
        // validation for constraint: string
        if (!is_null($municipality) && !is_string($municipality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipality)), __LINE__);
        }
        $this->Municipality = $municipality;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\Address
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \StructType\Address
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get StreetNumber value
     * @return int|null
     */
    public function getStreetNumber()
    {
        return $this->StreetNumber;
    }
    /**
     * Set StreetNumber value
     * @param int $streetNumber
     * @return \StructType\Address
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: int
        if (!is_null($streetNumber) && !is_numeric($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($streetNumber)), __LINE__);
        }
        $this->StreetNumber = $streetNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
