<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetStudentBasic
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudentBasic $parameters
     * @return \StructType\GetStudentBasicResponse|bool
     */
    public function GetStudentBasic(\StructType\GetStudentBasic $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudentBasic($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStudentTransBasic
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudentTransBasic $parameters
     * @return \StructType\GetStudentTransBasicResponse|bool
     */
    public function GetStudentTransBasic(\StructType\GetStudentTransBasic $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudentTransBasic($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStudentsWithTransChanges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudentsWithTransChanges $parameters
     * @return \StructType\GetStudentsWithTransChangesResponse|bool
     */
    public function GetStudentsWithTransChanges(\StructType\GetStudentsWithTransChanges $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudentsWithTransChanges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetStudentsWhoHaveTravelCodeChanges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudentsWhoHaveTravelCodeChanges $parameters
     * @return \StructType\GetStudentsWhoHaveTravelCodeChangesResponse|bool
     */
    public function GetStudentsWhoHaveTravelCodeChanges(\StructType\GetStudentsWhoHaveTravelCodeChanges $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudentsWhoHaveTravelCodeChanges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStudentTransChangesXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllStudentTransChangesXML $parameters
     * @return \StructType\GetAllStudentTransChangesXMLResponse|bool
     */
    public function GetAllStudentTransChangesXML(\StructType\GetAllStudentTransChangesXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStudentTransChangesXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStudentTransInformationXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudentTransInformationXML $parameters
     * @return \StructType\GetStudentTransInformationXMLResponse|bool
     */
    public function GetStudentTransInformationXML(\StructType\GetStudentTransInformationXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudentTransInformationXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStudentStandard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudentStandard $parameters
     * @return \StructType\GetStudentStandardResponse|bool
     */
    public function GetStudentStandard(\StructType\GetStudentStandard $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudentStandard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllContactTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllContactTypes $parameters
     * @return \StructType\GetAllContactTypesResponse|bool
     */
    public function GetAllContactTypes(\StructType\GetAllContactTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllContactTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContacts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContacts $parameters
     * @return \StructType\GetContactsResponse|bool
     */
    public function GetContacts(\StructType\GetContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStudentComplete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudentComplete $parameters
     * @return \StructType\GetStudentCompleteResponse|bool
     */
    public function GetStudentComplete(\StructType\GetStudentComplete $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudentComplete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStudentsComplete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudentsComplete $parameters
     * @return \StructType\GetStudentsCompleteResponse|bool
     */
    public function GetStudentsComplete(\StructType\GetStudentsComplete $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudentsComplete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllContacts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllContacts $parameters
     * @return \StructType\GetAllContactsResponse|bool
     */
    public function GetAllContacts(\StructType\GetAllContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStudentStandard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllStudentStandard $parameters
     * @return \StructType\GetAllStudentStandardResponse|bool
     */
    public function GetAllStudentStandard(\StructType\GetAllStudentStandard $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStudentStandard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStudentComplete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllStudentComplete $parameters
     * @return \StructType\GetAllStudentCompleteResponse|bool
     */
    public function GetAllStudentComplete(\StructType\GetAllStudentComplete $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStudentComplete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStudentStopAssignments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllStudentStopAssignments $parameters
     * @return \StructType\GetAllStudentStopAssignmentsResponse|bool
     */
    public function GetAllStudentStopAssignments(\StructType\GetAllStudentStopAssignments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStudentStopAssignments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllHomeStops
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllHomeStops $parameters
     * @return \StructType\GetAllHomeStopsResponse|bool
     */
    public function GetAllHomeStops(\StructType\GetAllHomeStops $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllHomeStops($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSchoolStops
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchoolStops $parameters
     * @return \StructType\GetAllSchoolStopsResponse|bool
     */
    public function GetAllSchoolStops(\StructType\GetAllSchoolStops $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchoolStops($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllTransfers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllTransfers $parameters
     * @return \StructType\GetAllTransfersResponse|bool
     */
    public function GetAllTransfers(\StructType\GetAllTransfers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllTransfers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSchoolsServicedByStop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSchoolsServicedByStop $parameters
     * @return \StructType\GetSchoolsServicedByStopResponse|bool
     */
    public function GetSchoolsServicedByStop(\StructType\GetSchoolsServicedByStop $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSchoolsServicedByStop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSchools
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchools $parameters
     * @return \StructType\GetAllSchoolsResponse|bool
     */
    public function GetAllSchools(\StructType\GetAllSchools $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchools($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllRuns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllRuns $parameters
     * @return \StructType\GetAllRunsResponse|bool
     */
    public function GetAllRuns(\StructType\GetAllRuns $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllRuns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllRoutes $parameters
     * @return \StructType\GetAllRoutesResponse|bool
     */
    public function GetAllRoutes(\StructType\GetAllRoutes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllRoutes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllDistricts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllDistricts $parameters
     * @return \StructType\GetAllDistrictsResponse|bool
     */
    public function GetAllDistricts(\StructType\GetAllDistricts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllDistricts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllVehicles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllVehicles $parameters
     * @return \StructType\GetAllVehiclesResponse|bool
     */
    public function GetAllVehicles(\StructType\GetAllVehicles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllOperators
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllOperators $parameters
     * @return \StructType\GetAllOperatorsResponse|bool
     */
    public function GetAllOperators(\StructType\GetAllOperators $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllOperators($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllDepots
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllDepots $parameters
     * @return \StructType\GetAllDepotsResponse|bool
     */
    public function GetAllDepots(\StructType\GetAllDepots $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllDepots($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllGrades
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllGrades $parameters
     * @return \StructType\GetAllGradesResponse|bool
     */
    public function GetAllGrades(\StructType\GetAllGrades $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllGrades($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllPrograms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllPrograms $parameters
     * @return \StructType\GetAllProgramsResponse|bool
     */
    public function GetAllPrograms(\StructType\GetAllPrograms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllPrograms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSchoolProgramBellTimes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchoolProgramBellTimes $parameters
     * @return \StructType\GetAllSchoolProgramBellTimesResponse|bool
     */
    public function GetAllSchoolProgramBellTimes(\StructType\GetAllSchoolProgramBellTimes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchoolProgramBellTimes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStudentPrograms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllStudentPrograms $parameters
     * @return \StructType\GetAllStudentProgramsResponse|bool
     */
    public function GetAllStudentPrograms(\StructType\GetAllStudentPrograms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStudentPrograms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStudentRideTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudentRideTime $parameters
     * @return \StructType\GetStudentRideTimeResponse|bool
     */
    public function GetStudentRideTime(\StructType\GetStudentRideTime $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudentRideTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllComponents
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllComponents $parameters
     * @return \StructType\GetAllComponentsResponse|bool
     */
    public function GetAllComponents(\StructType\GetAllComponents $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllComponents($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWayPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWayPoints $parameters
     * @return \StructType\GetWayPointsResponse|bool
     */
    public function GetWayPoints(\StructType\GetWayPoints $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWayPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllZoneTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllZoneTypes $parameters
     * @return \StructType\GetAllZoneTypesResponse|bool
     */
    public function GetAllZoneTypes(\StructType\GetAllZoneTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllZoneTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllZonesByType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllZonesByType $parameters
     * @return \StructType\GetAllZonesByTypeResponse|bool
     */
    public function GetAllZonesByType(\StructType\GetAllZonesByType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllZonesByType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccidentCountForOperator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccidentCountForOperator $parameters
     * @return \StructType\GetAccidentCountForOperatorResponse|bool
     */
    public function GetAccidentCountForOperator(\StructType\GetAccidentCountForOperator $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccidentCountForOperator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIncidentCountForOperator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIncidentCountForOperator $parameters
     * @return \StructType\GetIncidentCountForOperatorResponse|bool
     */
    public function GetIncidentCountForOperator(\StructType\GetIncidentCountForOperator $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetIncidentCountForOperator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllAccessPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllAccessPoints $parameters
     * @return \StructType\GetAllAccessPointsResponse|bool
     */
    public function GetAllAccessPoints(\StructType\GetAllAccessPoints $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllAccessPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllCorners
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllCorners $parameters
     * @return \StructType\GetAllCornersResponse|bool
     */
    public function GetAllCorners(\StructType\GetAllCorners $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllCorners($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllDeadheads
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllDeadheads $parameters
     * @return \StructType\GetAllDeadheadsResponse|bool
     */
    public function GetAllDeadheads(\StructType\GetAllDeadheads $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllDeadheads($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllDeadheadWaypoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllDeadheadWaypoints $parameters
     * @return \StructType\GetAllDeadheadWaypointsResponse|bool
     */
    public function GetAllDeadheadWaypoints(\StructType\GetAllDeadheadWaypoints $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllDeadheadWaypoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllExceptionBoundaries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllExceptionBoundaries $parameters
     * @return \StructType\GetAllExceptionBoundariesResponse|bool
     */
    public function GetAllExceptionBoundaries(\StructType\GetAllExceptionBoundaries $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllExceptionBoundaries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllExceptionBoundarySchools
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllExceptionBoundarySchools $parameters
     * @return \StructType\GetAllExceptionBoundarySchoolsResponse|bool
     */
    public function GetAllExceptionBoundarySchools(\StructType\GetAllExceptionBoundarySchools $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllExceptionBoundarySchools($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllExceptionBoundaryGrades
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllExceptionBoundaryGrades $parameters
     * @return \StructType\GetAllExceptionBoundaryGradesResponse|bool
     */
    public function GetAllExceptionBoundaryGrades(\StructType\GetAllExceptionBoundaryGrades $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllExceptionBoundaryGrades($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllExceptionBoundaryPrograms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllExceptionBoundaryPrograms $parameters
     * @return \StructType\GetAllExceptionBoundaryProgramsResponse|bool
     */
    public function GetAllExceptionBoundaryPrograms(\StructType\GetAllExceptionBoundaryPrograms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllExceptionBoundaryPrograms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSchoolBoundaries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchoolBoundaries $parameters
     * @return \StructType\GetAllSchoolBoundariesResponse|bool
     */
    public function GetAllSchoolBoundaries(\StructType\GetAllSchoolBoundaries $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchoolBoundaries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSchoolBoundaryGrades
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchoolBoundaryGrades $parameters
     * @return \StructType\GetAllSchoolBoundaryGradesResponse|bool
     */
    public function GetAllSchoolBoundaryGrades(\StructType\GetAllSchoolBoundaryGrades $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchoolBoundaryGrades($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSchoolBoundaryPrograms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchoolBoundaryPrograms $parameters
     * @return \StructType\GetAllSchoolBoundaryProgramsResponse|bool
     */
    public function GetAllSchoolBoundaryPrograms(\StructType\GetAllSchoolBoundaryPrograms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchoolBoundaryPrograms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllLocations $parameters
     * @return \StructType\GetAllLocationsResponse|bool
     */
    public function GetAllLocations(\StructType\GetAllLocations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllDistricts_v2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllDistricts_v2 $parameters
     * @return \StructType\GetAllDistricts_v2Response|bool
     */
    public function GetAllDistricts_v2(\StructType\GetAllDistricts_v2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllDistricts_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllRuns_v2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllRuns_v2 $parameters
     * @return \StructType\GetAllRuns_v2Response|bool
     */
    public function GetAllRuns_v2(\StructType\GetAllRuns_v2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllRuns_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSchoolGrades
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchoolGrades $parameters
     * @return \StructType\GetAllSchoolGradesResponse|bool
     */
    public function GetAllSchoolGrades(\StructType\GetAllSchoolGrades $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchoolGrades($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSchoolGradePrograms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchoolGradePrograms $parameters
     * @return \StructType\GetAllSchoolGradeProgramsResponse|bool
     */
    public function GetAllSchoolGradePrograms(\StructType\GetAllSchoolGradePrograms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchoolGradePrograms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllAddresses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllAddresses $parameters
     * @return \StructType\GetAllAddressesResponse|bool
     */
    public function GetAllAddresses(\StructType\GetAllAddresses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllPolicies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllPolicies $parameters
     * @return \StructType\GetAllPoliciesResponse|bool
     */
    public function GetAllPolicies(\StructType\GetAllPolicies $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllPolicies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllGPSRouteVehicles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllGPSRouteVehicles $parameters
     * @return \StructType\GetAllGPSRouteVehiclesResponse|bool
     */
    public function GetAllGPSRouteVehicles(\StructType\GetAllGPSRouteVehicles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllGPSRouteVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSchools_v2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchools_v2 $parameters
     * @return \StructType\GetAllSchools_v2Response|bool
     */
    public function GetAllSchools_v2(\StructType\GetAllSchools_v2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchools_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllVehicleTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllVehicleTypes $parameters
     * @return \StructType\GetAllVehicleTypesResponse|bool
     */
    public function GetAllVehicleTypes(\StructType\GetAllVehicleTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllVehicleTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllDrivers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllDrivers $parameters
     * @return \StructType\GetAllDriversResponse|bool
     */
    public function GetAllDrivers(\StructType\GetAllDrivers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllDrivers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllDriverSchedules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllDriverSchedules $parameters
     * @return \StructType\GetAllDriverSchedulesResponse|bool
     */
    public function GetAllDriverSchedules(\StructType\GetAllDriverSchedules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllDriverSchedules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDatabaseDescriptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDatabaseDescriptions $parameters
     * @return \StructType\GetDatabaseDescriptionsResponse|bool
     */
    public function GetDatabaseDescriptions(\StructType\GetDatabaseDescriptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDatabaseDescriptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDatabaseGuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDatabaseGuid $parameters
     * @return \StructType\GetDatabaseGuidResponse|bool
     */
    public function GetDatabaseGuid(\StructType\GetDatabaseGuid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDatabaseGuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllRunPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllRunPoints $parameters
     * @return \StructType\GetAllRunPointsResponse|bool
     */
    public function GetAllRunPoints(\StructType\GetAllRunPoints $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllRunPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRouteItinerary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouteItinerary $parameters
     * @return \StructType\GetRouteItineraryResponse|bool
     */
    public function GetRouteItinerary(\StructType\GetRouteItinerary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRouteItinerary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStreetList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStreetList $parameters
     * @return \StructType\GetStreetListResponse|bool
     */
    public function GetStreetList(\StructType\GetStreetList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStreetList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAddressEligibility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddressEligibility $parameters
     * @return \StructType\GetAddressEligibilityResponse|bool
     */
    public function GetAddressEligibility(\StructType\GetAddressEligibility $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAddressEligibility($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccidentCountForOperatorResponse|\StructType\GetAddressEligibilityResponse|\StructType\GetAllAccessPointsResponse|\StructType\GetAllAddressesResponse|\StructType\GetAllComponentsResponse|\StructType\GetAllContactsResponse|\StructType\GetAllContactTypesResponse|\StructType\GetAllCornersResponse|\StructType\GetAllDeadheadsResponse|\StructType\GetAllDeadheadWaypointsResponse|\StructType\GetAllDepotsResponse|\StructType\GetAllDistrictsResponse|\StructType\GetAllDistricts_v2Response|\StructType\GetAllDriverSchedulesResponse|\StructType\GetAllDriversResponse|\StructType\GetAllExceptionBoundariesResponse|\StructType\GetAllExceptionBoundaryGradesResponse|\StructType\GetAllExceptionBoundaryProgramsResponse|\StructType\GetAllExceptionBoundarySchoolsResponse|\StructType\GetAllGPSRouteVehiclesResponse|\StructType\GetAllGradesResponse|\StructType\GetAllHomeStopsResponse|\StructType\GetAllLocationsResponse|\StructType\GetAllOperatorsResponse|\StructType\GetAllPoliciesResponse|\StructType\GetAllProgramsResponse|\StructType\GetAllRoutesResponse|\StructType\GetAllRunPointsResponse|\StructType\GetAllRunsResponse|\StructType\GetAllRuns_v2Response|\StructType\GetAllSchoolBoundariesResponse|\StructType\GetAllSchoolBoundaryGradesResponse|\StructType\GetAllSchoolBoundaryProgramsResponse|\StructType\GetAllSchoolGradeProgramsResponse|\StructType\GetAllSchoolGradesResponse|\StructType\GetAllSchoolProgramBellTimesResponse|\StructType\GetAllSchoolsResponse|\StructType\GetAllSchoolStopsResponse|\StructType\GetAllSchools_v2Response|\StructType\GetAllStudentCompleteResponse|\StructType\GetAllStudentProgramsResponse|\StructType\GetAllStudentStandardResponse|\StructType\GetAllStudentStopAssignmentsResponse|\StructType\GetAllStudentTransChangesXMLResponse|\StructType\GetAllTransfersResponse|\StructType\GetAllVehiclesResponse|\StructType\GetAllVehicleTypesResponse|\StructType\GetAllZonesByTypeResponse|\StructType\GetAllZoneTypesResponse|\StructType\GetContactsResponse|\StructType\GetDatabaseDescriptionsResponse|\StructType\GetDatabaseGuidResponse|\StructType\GetIncidentCountForOperatorResponse|\StructType\GetRouteItineraryResponse|\StructType\GetSchoolsServicedByStopResponse|\StructType\GetStreetListResponse|\StructType\GetStudentBasicResponse|\StructType\GetStudentCompleteResponse|\StructType\GetStudentRideTimeResponse|\StructType\GetStudentsCompleteResponse|\StructType\GetStudentStandardResponse|\StructType\GetStudentsWhoHaveTravelCodeChangesResponse|\StructType\GetStudentsWithTransChangesResponse|\StructType\GetStudentTransBasicResponse|\StructType\GetStudentTransInformationXMLResponse|\StructType\GetWayPointsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
