<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSchool ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSchool
 * @subpackage Arrays
 */
class ArrayOfSchool extends AbstractStructArrayBase
{
    /**
     * The School
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\School[]
     */
    public $School;
    /**
     * Constructor method for ArrayOfSchool
     * @uses ArrayOfSchool::setSchool()
     * @param \StructType\School[] $school
     */
    public function __construct(array $school = array())
    {
        $this
            ->setSchool($school);
    }
    /**
     * Get School value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\School[]|null
     */
    public function getSchool()
    {
        return isset($this->School) ? $this->School : null;
    }
    /**
     * Set School value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\School[] $school
     * @return \ArrayType\ArrayOfSchool
     */
    public function setSchool(array $school = array())
    {
        foreach ($school as $arrayOfSchoolSchoolItem) {
            // validation for constraint: itemType
            if (!$arrayOfSchoolSchoolItem instanceof \StructType\School) {
                throw new \InvalidArgumentException(sprintf('The School property can only contain items of \StructType\School, "%s" given', is_object($arrayOfSchoolSchoolItem) ? get_class($arrayOfSchoolSchoolItem) : gettype($arrayOfSchoolSchoolItem)), __LINE__);
            }
        }
        if (is_null($school) || (is_array($school) && empty($school))) {
            unset($this->School);
        } else {
            $this->School = $school;
        }
        return $this;
    }
    /**
     * Add item to School value
     * @throws \InvalidArgumentException
     * @param \StructType\School $item
     * @return \ArrayType\ArrayOfSchool
     */
    public function addToSchool(\StructType\School $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\School) {
            throw new \InvalidArgumentException(sprintf('The School property can only contain items of \StructType\School, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->School[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\School|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\School|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\School|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\School|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\School|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string School
     */
    public function getAttributeName()
    {
        return 'School';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSchool
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
