<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRun ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRun
 * @subpackage Arrays
 */
class ArrayOfRun extends AbstractStructArrayBase
{
    /**
     * The Run
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Run[]
     */
    public $Run;
    /**
     * Constructor method for ArrayOfRun
     * @uses ArrayOfRun::setRun()
     * @param \StructType\Run[] $run
     */
    public function __construct(array $run = array())
    {
        $this
            ->setRun($run);
    }
    /**
     * Get Run value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Run[]|null
     */
    public function getRun()
    {
        return isset($this->Run) ? $this->Run : null;
    }
    /**
     * Set Run value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Run[] $run
     * @return \ArrayType\ArrayOfRun
     */
    public function setRun(array $run = array())
    {
        foreach ($run as $arrayOfRunRunItem) {
            // validation for constraint: itemType
            if (!$arrayOfRunRunItem instanceof \StructType\Run) {
                throw new \InvalidArgumentException(sprintf('The Run property can only contain items of \StructType\Run, "%s" given', is_object($arrayOfRunRunItem) ? get_class($arrayOfRunRunItem) : gettype($arrayOfRunRunItem)), __LINE__);
            }
        }
        if (is_null($run) || (is_array($run) && empty($run))) {
            unset($this->Run);
        } else {
            $this->Run = $run;
        }
        return $this;
    }
    /**
     * Add item to Run value
     * @throws \InvalidArgumentException
     * @param \StructType\Run $item
     * @return \ArrayType\ArrayOfRun
     */
    public function addToRun(\StructType\Run $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Run) {
            throw new \InvalidArgumentException(sprintf('The Run property can only contain items of \StructType\Run, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Run[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Run|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Run|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Run|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Run|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Run|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Run
     */
    public function getAttributeName()
    {
        return 'Run';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRun
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
