<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoute ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRoute
 * @subpackage Arrays
 */
class ArrayOfRoute extends AbstractStructArrayBase
{
    /**
     * The Route
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Route[]
     */
    public $Route;
    /**
     * Constructor method for ArrayOfRoute
     * @uses ArrayOfRoute::setRoute()
     * @param \StructType\Route[] $route
     */
    public function __construct(array $route = array())
    {
        $this
            ->setRoute($route);
    }
    /**
     * Get Route value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Route[]|null
     */
    public function getRoute()
    {
        return isset($this->Route) ? $this->Route : null;
    }
    /**
     * Set Route value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Route[] $route
     * @return \ArrayType\ArrayOfRoute
     */
    public function setRoute(array $route = array())
    {
        foreach ($route as $arrayOfRouteRouteItem) {
            // validation for constraint: itemType
            if (!$arrayOfRouteRouteItem instanceof \StructType\Route) {
                throw new \InvalidArgumentException(sprintf('The Route property can only contain items of \StructType\Route, "%s" given', is_object($arrayOfRouteRouteItem) ? get_class($arrayOfRouteRouteItem) : gettype($arrayOfRouteRouteItem)), __LINE__);
            }
        }
        if (is_null($route) || (is_array($route) && empty($route))) {
            unset($this->Route);
        } else {
            $this->Route = $route;
        }
        return $this;
    }
    /**
     * Add item to Route value
     * @throws \InvalidArgumentException
     * @param \StructType\Route $item
     * @return \ArrayType\ArrayOfRoute
     */
    public function addToRoute(\StructType\Route $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Route) {
            throw new \InvalidArgumentException(sprintf('The Route property can only contain items of \StructType\Route, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Route[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Route|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Route|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Route|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Route|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Route|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Route
     */
    public function getAttributeName()
    {
        return 'Route';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
