<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOperator ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOperator
 * @subpackage Arrays
 */
class ArrayOfOperator extends AbstractStructArrayBase
{
    /**
     * The Operator
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Operator[]
     */
    public $Operator;
    /**
     * Constructor method for ArrayOfOperator
     * @uses ArrayOfOperator::setOperator()
     * @param \StructType\Operator[] $operator
     */
    public function __construct(array $operator = array())
    {
        $this
            ->setOperator($operator);
    }
    /**
     * Get Operator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Operator[]|null
     */
    public function getOperator()
    {
        return isset($this->Operator) ? $this->Operator : null;
    }
    /**
     * Set Operator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Operator[] $operator
     * @return \ArrayType\ArrayOfOperator
     */
    public function setOperator(array $operator = array())
    {
        foreach ($operator as $arrayOfOperatorOperatorItem) {
            // validation for constraint: itemType
            if (!$arrayOfOperatorOperatorItem instanceof \StructType\Operator) {
                throw new \InvalidArgumentException(sprintf('The Operator property can only contain items of \StructType\Operator, "%s" given', is_object($arrayOfOperatorOperatorItem) ? get_class($arrayOfOperatorOperatorItem) : gettype($arrayOfOperatorOperatorItem)), __LINE__);
            }
        }
        if (is_null($operator) || (is_array($operator) && empty($operator))) {
            unset($this->Operator);
        } else {
            $this->Operator = $operator;
        }
        return $this;
    }
    /**
     * Add item to Operator value
     * @throws \InvalidArgumentException
     * @param \StructType\Operator $item
     * @return \ArrayType\ArrayOfOperator
     */
    public function addToOperator(\StructType\Operator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Operator) {
            throw new \InvalidArgumentException(sprintf('The Operator property can only contain items of \StructType\Operator, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Operator[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Operator|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Operator|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Operator|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Operator|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Operator|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Operator
     */
    public function getAttributeName()
    {
        return 'Operator';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOperator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
