<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEnrollment ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEnrollment
 * @subpackage Arrays
 */
class ArrayOfEnrollment extends AbstractStructArrayBase
{
    /**
     * The Enrollment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Enrollment[]
     */
    public $Enrollment;
    /**
     * Constructor method for ArrayOfEnrollment
     * @uses ArrayOfEnrollment::setEnrollment()
     * @param \StructType\Enrollment[] $enrollment
     */
    public function __construct(array $enrollment = array())
    {
        $this
            ->setEnrollment($enrollment);
    }
    /**
     * Get Enrollment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Enrollment[]|null
     */
    public function getEnrollment()
    {
        return isset($this->Enrollment) ? $this->Enrollment : null;
    }
    /**
     * Set Enrollment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Enrollment[] $enrollment
     * @return \ArrayType\ArrayOfEnrollment
     */
    public function setEnrollment(array $enrollment = array())
    {
        foreach ($enrollment as $arrayOfEnrollmentEnrollmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfEnrollmentEnrollmentItem instanceof \StructType\Enrollment) {
                throw new \InvalidArgumentException(sprintf('The Enrollment property can only contain items of \StructType\Enrollment, "%s" given', is_object($arrayOfEnrollmentEnrollmentItem) ? get_class($arrayOfEnrollmentEnrollmentItem) : gettype($arrayOfEnrollmentEnrollmentItem)), __LINE__);
            }
        }
        if (is_null($enrollment) || (is_array($enrollment) && empty($enrollment))) {
            unset($this->Enrollment);
        } else {
            $this->Enrollment = $enrollment;
        }
        return $this;
    }
    /**
     * Add item to Enrollment value
     * @throws \InvalidArgumentException
     * @param \StructType\Enrollment $item
     * @return \ArrayType\ArrayOfEnrollment
     */
    public function addToEnrollment(\StructType\Enrollment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Enrollment) {
            throw new \InvalidArgumentException(sprintf('The Enrollment property can only contain items of \StructType\Enrollment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Enrollment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Enrollment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Enrollment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Enrollment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Enrollment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Enrollment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Enrollment
     */
    public function getAttributeName()
    {
        return 'Enrollment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEnrollment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
