<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCorner ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCorner
 * @subpackage Arrays
 */
class ArrayOfCorner extends AbstractStructArrayBase
{
    /**
     * The Corner
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Corner[]
     */
    public $Corner;
    /**
     * Constructor method for ArrayOfCorner
     * @uses ArrayOfCorner::setCorner()
     * @param \StructType\Corner[] $corner
     */
    public function __construct(array $corner = array())
    {
        $this
            ->setCorner($corner);
    }
    /**
     * Get Corner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Corner[]|null
     */
    public function getCorner()
    {
        return isset($this->Corner) ? $this->Corner : null;
    }
    /**
     * Set Corner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Corner[] $corner
     * @return \ArrayType\ArrayOfCorner
     */
    public function setCorner(array $corner = array())
    {
        foreach ($corner as $arrayOfCornerCornerItem) {
            // validation for constraint: itemType
            if (!$arrayOfCornerCornerItem instanceof \StructType\Corner) {
                throw new \InvalidArgumentException(sprintf('The Corner property can only contain items of \StructType\Corner, "%s" given', is_object($arrayOfCornerCornerItem) ? get_class($arrayOfCornerCornerItem) : gettype($arrayOfCornerCornerItem)), __LINE__);
            }
        }
        if (is_null($corner) || (is_array($corner) && empty($corner))) {
            unset($this->Corner);
        } else {
            $this->Corner = $corner;
        }
        return $this;
    }
    /**
     * Add item to Corner value
     * @throws \InvalidArgumentException
     * @param \StructType\Corner $item
     * @return \ArrayType\ArrayOfCorner
     */
    public function addToCorner(\StructType\Corner $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Corner) {
            throw new \InvalidArgumentException(sprintf('The Corner property can only contain items of \StructType\Corner, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Corner[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Corner|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Corner|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Corner|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Corner|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Corner|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Corner
     */
    public function getAttributeName()
    {
        return 'Corner';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCorner
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
