<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactType ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfContactType
 * @subpackage Arrays
 */
class ArrayOfContactType extends AbstractStructArrayBase
{
    /**
     * The ContactType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactType[]
     */
    public $ContactType;
    /**
     * Constructor method for ArrayOfContactType
     * @uses ArrayOfContactType::setContactType()
     * @param \StructType\ContactType[] $contactType
     */
    public function __construct(array $contactType = array())
    {
        $this
            ->setContactType($contactType);
    }
    /**
     * Get ContactType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactType[]|null
     */
    public function getContactType()
    {
        return isset($this->ContactType) ? $this->ContactType : null;
    }
    /**
     * Set ContactType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactType[] $contactType
     * @return \ArrayType\ArrayOfContactType
     */
    public function setContactType(array $contactType = array())
    {
        foreach ($contactType as $arrayOfContactTypeContactTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactTypeContactTypeItem instanceof \StructType\ContactType) {
                throw new \InvalidArgumentException(sprintf('The ContactType property can only contain items of \StructType\ContactType, "%s" given', is_object($arrayOfContactTypeContactTypeItem) ? get_class($arrayOfContactTypeContactTypeItem) : gettype($arrayOfContactTypeContactTypeItem)), __LINE__);
            }
        }
        if (is_null($contactType) || (is_array($contactType) && empty($contactType))) {
            unset($this->ContactType);
        } else {
            $this->ContactType = $contactType;
        }
        return $this;
    }
    /**
     * Add item to ContactType value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactType $item
     * @return \ArrayType\ArrayOfContactType
     */
    public function addToContactType(\StructType\ContactType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactType) {
            throw new \InvalidArgumentException(sprintf('The ContactType property can only contain items of \StructType\ContactType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactType
     */
    public function getAttributeName()
    {
        return 'ContactType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
