<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddress_v2 ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAddress_v2
 * @subpackage Arrays
 */
class ArrayOfAddress_v2 extends AbstractStructArrayBase
{
    /**
     * The Address_v2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address_v2[]
     */
    public $Address_v2;
    /**
     * Constructor method for ArrayOfAddress_v2
     * @uses ArrayOfAddress_v2::setAddress_v2()
     * @param \StructType\Address_v2[] $address_v2
     */
    public function __construct(array $address_v2 = array())
    {
        $this
            ->setAddress_v2($address_v2);
    }
    /**
     * Get Address_v2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address_v2[]|null
     */
    public function getAddress_v2()
    {
        return isset($this->Address_v2) ? $this->Address_v2 : null;
    }
    /**
     * Set Address_v2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Address_v2[] $address_v2
     * @return \ArrayType\ArrayOfAddress_v2
     */
    public function setAddress_v2(array $address_v2 = array())
    {
        foreach ($address_v2 as $arrayOfAddress_v2Address_v2Item) {
            // validation for constraint: itemType
            if (!$arrayOfAddress_v2Address_v2Item instanceof \StructType\Address_v2) {
                throw new \InvalidArgumentException(sprintf('The Address_v2 property can only contain items of \StructType\Address_v2, "%s" given', is_object($arrayOfAddress_v2Address_v2Item) ? get_class($arrayOfAddress_v2Address_v2Item) : gettype($arrayOfAddress_v2Address_v2Item)), __LINE__);
            }
        }
        if (is_null($address_v2) || (is_array($address_v2) && empty($address_v2))) {
            unset($this->Address_v2);
        } else {
            $this->Address_v2 = $address_v2;
        }
        return $this;
    }
    /**
     * Add item to Address_v2 value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_v2 $item
     * @return \ArrayType\ArrayOfAddress_v2
     */
    public function addToAddress_v2(\StructType\Address_v2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address_v2) {
            throw new \InvalidArgumentException(sprintf('The Address_v2 property can only contain items of \StructType\Address_v2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address_v2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Address_v2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Address_v2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Address_v2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Address_v2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Address_v2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Address_v2
     */
    public function getAttributeName()
    {
        return 'Address_v2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAddress_v2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
