<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddressEligibility ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAddressEligibility
 * @subpackage Arrays
 */
class ArrayOfAddressEligibility extends AbstractStructArrayBase
{
    /**
     * The AddressEligibility
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressEligibility[]
     */
    public $AddressEligibility;
    /**
     * Constructor method for ArrayOfAddressEligibility
     * @uses ArrayOfAddressEligibility::setAddressEligibility()
     * @param \StructType\AddressEligibility[] $addressEligibility
     */
    public function __construct(array $addressEligibility = array())
    {
        $this
            ->setAddressEligibility($addressEligibility);
    }
    /**
     * Get AddressEligibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressEligibility[]|null
     */
    public function getAddressEligibility()
    {
        return isset($this->AddressEligibility) ? $this->AddressEligibility : null;
    }
    /**
     * Set AddressEligibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddressEligibility[] $addressEligibility
     * @return \ArrayType\ArrayOfAddressEligibility
     */
    public function setAddressEligibility(array $addressEligibility = array())
    {
        foreach ($addressEligibility as $arrayOfAddressEligibilityAddressEligibilityItem) {
            // validation for constraint: itemType
            if (!$arrayOfAddressEligibilityAddressEligibilityItem instanceof \StructType\AddressEligibility) {
                throw new \InvalidArgumentException(sprintf('The AddressEligibility property can only contain items of \StructType\AddressEligibility, "%s" given', is_object($arrayOfAddressEligibilityAddressEligibilityItem) ? get_class($arrayOfAddressEligibilityAddressEligibilityItem) : gettype($arrayOfAddressEligibilityAddressEligibilityItem)), __LINE__);
            }
        }
        if (is_null($addressEligibility) || (is_array($addressEligibility) && empty($addressEligibility))) {
            unset($this->AddressEligibility);
        } else {
            $this->AddressEligibility = $addressEligibility;
        }
        return $this;
    }
    /**
     * Add item to AddressEligibility value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressEligibility $item
     * @return \ArrayType\ArrayOfAddressEligibility
     */
    public function addToAddressEligibility(\StructType\AddressEligibility $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressEligibility) {
            throw new \InvalidArgumentException(sprintf('The AddressEligibility property can only contain items of \StructType\AddressEligibility, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressEligibility[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AddressEligibility|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AddressEligibility|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AddressEligibility|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AddressEligibility|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AddressEligibility|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AddressEligibility
     */
    public function getAttributeName()
    {
        return 'AddressEligibility';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAddressEligibility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
