<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://pruebasclientes.facturehoy.com:7777/CancelacionCFDI/WsCancelacionCFDI33?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://pruebasclientes.facturehoy.com:7777/CancelacionCFDI/WsCancelacionCFDI33?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancelar ServiceType
 */
$cancelar = new \ServiceType\Cancelar($options);
/**
 * Sample call for CancelarCFDI operation/method
 */
if ($cancelar->CancelarCFDI(new \StructType\CancelarCFDI()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Sample call for CancelarCFDICA operation/method
 */
if ($cancelar->CancelarCFDICA(new \StructType\CancelarCFDICA()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Samples for Obtiene ServiceType
 */
$obtiene = new \ServiceType\Obtiene($options);
/**
 * Sample call for ObtienePeticionesPendientes operation/method
 */
if ($obtiene->ObtienePeticionesPendientes(new \StructType\ObtienePeticionesPendientes()) !== false) {
    print_r($obtiene->getResult());
} else {
    print_r($obtiene->getLastError());
}
/**
 * Sample call for ObtienePeticionesPendientesCA operation/method
 */
if ($obtiene->ObtienePeticionesPendientesCA(new \StructType\ObtienePeticionesPendientesCA()) !== false) {
    print_r($obtiene->getResult());
} else {
    print_r($obtiene->getLastError());
}
/**
 * Samples for Aceptar ServiceType
 */
$aceptar = new \ServiceType\Aceptar($options);
/**
 * Sample call for AceptarRechazarCancelacion operation/method
 */
if ($aceptar->AceptarRechazarCancelacion(new \StructType\AceptarRechazarCancelacion()) !== false) {
    print_r($aceptar->getResult());
} else {
    print_r($aceptar->getLastError());
}
/**
 * Sample call for AceptarRechazarCancelacionCA operation/method
 */
if ($aceptar->AceptarRechazarCancelacionCA(new \StructType\AceptarRechazarCancelacionCA()) !== false) {
    print_r($aceptar->getResult());
} else {
    print_r($aceptar->getLastError());
}
