<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Obtiene ServiceType
 * @subpackage Services
 */
class Obtiene extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ObtienePeticionesPendientes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtienePeticionesPendientes $parameters
     * @return \StructType\ObtienePeticionesPendientesResponse|bool
     */
    public function ObtienePeticionesPendientes(\StructType\ObtienePeticionesPendientes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ObtienePeticionesPendientes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ObtienePeticionesPendientesCA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtienePeticionesPendientesCA $parameters
     * @return \StructType\ObtienePeticionesPendientesCAResponse|bool
     */
    public function ObtienePeticionesPendientesCA(\StructType\ObtienePeticionesPendientesCA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ObtienePeticionesPendientesCA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ObtienePeticionesPendientesCAResponse|\StructType\ObtienePeticionesPendientesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
