<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancelar ServiceType
 * @subpackage Services
 */
class Cancelar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelarCFDI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelarCFDI $parameters
     * @return \StructType\CancelarCFDIResponse|bool
     */
    public function CancelarCFDI(\StructType\CancelarCFDI $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelarCFDI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelarCFDICA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelarCFDICA $parameters
     * @return \StructType\CancelarCFDICAResponse|bool
     */
    public function CancelarCFDICA(\StructType\CancelarCFDICA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelarCFDICA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelarCFDICAResponse|\StructType\CancelarCFDIResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
