<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnstructuredDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Неструктурированные сведения о должнике
 * @subpackage Structs
 */
class UnstructuredDatumType extends InformationType
{
    /**
     * The textDatums
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Массив произвольных данных (текстовый)
     * @var string
     */
    public $textDatums;
    /**
     * The departmentName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование подразделения | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $departmentName;
    /**
     * The regionCode
     * Meta informations extracted from the WSDL
     * - documentation: Код региона | Код региона по КЛАДР
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $regionCode;
    /**
     * Constructor method for UnstructuredDatumType
     * @uses UnstructuredDatumType::setTextDatums()
     * @uses UnstructuredDatumType::setDepartmentName()
     * @uses UnstructuredDatumType::setRegionCode()
     * @param string $textDatums
     * @param string $departmentName
     * @param string $regionCode
     */
    public function __construct($textDatums = null, $departmentName = null, $regionCode = null)
    {
        $this
            ->setTextDatums($textDatums)
            ->setDepartmentName($departmentName)
            ->setRegionCode($regionCode);
    }
    /**
     * Get textDatums value
     * @return string|null
     */
    public function getTextDatums()
    {
        return $this->textDatums;
    }
    /**
     * Set textDatums value
     * @param string $textDatums
     * @return \StructType\UnstructuredDatumType
     */
    public function setTextDatums($textDatums = null)
    {
        $this->textDatums = $textDatums;
        return $this;
    }
    /**
     * Get departmentName value
     * @return string|null
     */
    public function getDepartmentName()
    {
        return $this->departmentName;
    }
    /**
     * Set departmentName value
     * @param string $departmentName
     * @return \StructType\UnstructuredDatumType
     */
    public function setDepartmentName($departmentName = null)
    {
        $this->departmentName = $departmentName;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\UnstructuredDatumType
     */
    public function setRegionCode($regionCode = null)
    {
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnstructuredDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
