<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnemployedPersonRegistrationDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о периоде нахождения на регистрационном учете в качестве безработного
 * @subpackage Structs
 */
class UnemployedPersonRegistrationDatumType extends InformationType
{
    /**
     * The RegistrationDateBegin
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала периода в качестве безработного | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegistrationDateBegin;
    /**
     * The RegistrationDateEnd
     * Meta informations extracted from the WSDL
     * - documentation: Дата конца периода в качестве безработного | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegistrationDateEnd;
    /**
     * The SearchDateBegin
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала периода в целях поиска подходящей работы | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $SearchDateBegin;
    /**
     * The SearchDateEnd
     * Meta informations extracted from the WSDL
     * - documentation: Дата конца периода в целях поиска подходящей работы | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $SearchDateEnd;
    /**
     * Constructor method for UnemployedPersonRegistrationDatumType
     * @uses UnemployedPersonRegistrationDatumType::setRegistrationDateBegin()
     * @uses UnemployedPersonRegistrationDatumType::setRegistrationDateEnd()
     * @uses UnemployedPersonRegistrationDatumType::setSearchDateBegin()
     * @uses UnemployedPersonRegistrationDatumType::setSearchDateEnd()
     * @param string $registrationDateBegin
     * @param string $registrationDateEnd
     * @param string $searchDateBegin
     * @param string $searchDateEnd
     */
    public function __construct($registrationDateBegin = null, $registrationDateEnd = null, $searchDateBegin = null, $searchDateEnd = null)
    {
        $this
            ->setRegistrationDateBegin($registrationDateBegin)
            ->setRegistrationDateEnd($registrationDateEnd)
            ->setSearchDateBegin($searchDateBegin)
            ->setSearchDateEnd($searchDateEnd);
    }
    /**
     * Get RegistrationDateBegin value
     * @return string|null
     */
    public function getRegistrationDateBegin()
    {
        return $this->RegistrationDateBegin;
    }
    /**
     * Set RegistrationDateBegin value
     * @param string $registrationDateBegin
     * @return \StructType\UnemployedPersonRegistrationDatumType
     */
    public function setRegistrationDateBegin($registrationDateBegin = null)
    {
        $this->RegistrationDateBegin = $registrationDateBegin;
        return $this;
    }
    /**
     * Get RegistrationDateEnd value
     * @return string|null
     */
    public function getRegistrationDateEnd()
    {
        return $this->RegistrationDateEnd;
    }
    /**
     * Set RegistrationDateEnd value
     * @param string $registrationDateEnd
     * @return \StructType\UnemployedPersonRegistrationDatumType
     */
    public function setRegistrationDateEnd($registrationDateEnd = null)
    {
        $this->RegistrationDateEnd = $registrationDateEnd;
        return $this;
    }
    /**
     * Get SearchDateBegin value
     * @return string|null
     */
    public function getSearchDateBegin()
    {
        return $this->SearchDateBegin;
    }
    /**
     * Set SearchDateBegin value
     * @param string $searchDateBegin
     * @return \StructType\UnemployedPersonRegistrationDatumType
     */
    public function setSearchDateBegin($searchDateBegin = null)
    {
        $this->SearchDateBegin = $searchDateBegin;
        return $this;
    }
    /**
     * Get SearchDateEnd value
     * @return string|null
     */
    public function getSearchDateEnd()
    {
        return $this->SearchDateEnd;
    }
    /**
     * Set SearchDateEnd value
     * @param string $searchDateEnd
     * @return \StructType\UnemployedPersonRegistrationDatumType
     */
    public function setSearchDateEnd($searchDateEnd = null)
    {
        $this->SearchDateEnd = $searchDateEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnemployedPersonRegistrationDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
