<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений TicketDatumType "Сведения о передвижении"
 * @subpackage Structs
 */
class TicketDatumType extends InformationType
{
    /**
     * The TicketDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время продажи билета | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $TicketDate;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выбытия должника из пункта назначения | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время прибытия должника в пункт назначения | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DepartureStation
     * Meta informations extracted from the WSDL
     * - documentation: Пункт отправления | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DepartureStation;
    /**
     * The DestinationStation
     * Meta informations extracted from the WSDL
     * - documentation: Пункт назначения | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DestinationStation;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Контактный номер телефона | Номер телефона
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $TelephoneNumber;
    /**
     * Constructor method for TicketDatumType
     * @uses TicketDatumType::setTicketDate()
     * @uses TicketDatumType::setDepartureDate()
     * @uses TicketDatumType::setArrivalDate()
     * @uses TicketDatumType::setDepartureStation()
     * @uses TicketDatumType::setDestinationStation()
     * @uses TicketDatumType::setTelephoneNumber()
     * @param string $ticketDate
     * @param string $departureDate
     * @param string $arrivalDate
     * @param string $departureStation
     * @param string $destinationStation
     * @param string $telephoneNumber
     */
    public function __construct($ticketDate = null, $departureDate = null, $arrivalDate = null, $departureStation = null, $destinationStation = null, $telephoneNumber = null)
    {
        $this
            ->setTicketDate($ticketDate)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setDepartureStation($departureStation)
            ->setDestinationStation($destinationStation)
            ->setTelephoneNumber($telephoneNumber);
    }
    /**
     * Get TicketDate value
     * @return string|null
     */
    public function getTicketDate()
    {
        return $this->TicketDate;
    }
    /**
     * Set TicketDate value
     * @param string $ticketDate
     * @return \StructType\TicketDatumType
     */
    public function setTicketDate($ticketDate = null)
    {
        $this->TicketDate = $ticketDate;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\TicketDatumType
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\TicketDatumType
     */
    public function setArrivalDate($arrivalDate = null)
    {
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DepartureStation value
     * @return string|null
     */
    public function getDepartureStation()
    {
        return $this->DepartureStation;
    }
    /**
     * Set DepartureStation value
     * @param string $departureStation
     * @return \StructType\TicketDatumType
     */
    public function setDepartureStation($departureStation = null)
    {
        $this->DepartureStation = $departureStation;
        return $this;
    }
    /**
     * Get DestinationStation value
     * @return string|null
     */
    public function getDestinationStation()
    {
        return $this->DestinationStation;
    }
    /**
     * Set DestinationStation value
     * @param string $destinationStation
     * @return \StructType\TicketDatumType
     */
    public function setDestinationStation($destinationStation = null)
    {
        $this->DestinationStation = $destinationStation;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * Set TelephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\TicketDatumType
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
