<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncRs StructType
 * @subpackage Structs
 */
abstract class SyncRs extends AbstractStructBase
{
    /**
     * The inquiryKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $inquiryKey;
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The origin
     * Meta informations extracted from the WSDL
     * - documentation: Адрес отправителя пакета
     * @var \StructType\RedAddress
     */
    public $origin;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - documentation: Адрес получателя пакета
     * @var \StructType\RedAddress
     */
    public $target;
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ошибки | Код ошибки
     * - minOccurs: 0
     * @var int
     */
    public $errorCode;
    /**
     * The errorText
     * Meta informations extracted from the WSDL
     * - documentation: Текст ошибки | Текст ошибки
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 0
     * @var string
     */
    public $errorText;
    /**
     * Constructor method for SyncRs
     * @uses SyncRs::setInquiryKey()
     * @uses SyncRs::setInternalKey()
     * @uses SyncRs::setOrigin()
     * @uses SyncRs::setTarget()
     * @uses SyncRs::setErrorCode()
     * @uses SyncRs::setErrorText()
     * @param string $inquiryKey
     * @param int $internalKey
     * @param \StructType\RedAddress $origin
     * @param \StructType\RedAddress $target
     * @param int $errorCode
     * @param string $errorText
     */
    public function __construct($inquiryKey = null, $internalKey = null, \StructType\RedAddress $origin = null, \StructType\RedAddress $target = null, $errorCode = null, $errorText = null)
    {
        $this
            ->setInquiryKey($inquiryKey)
            ->setInternalKey($internalKey)
            ->setOrigin($origin)
            ->setTarget($target)
            ->setErrorCode($errorCode)
            ->setErrorText($errorText);
    }
    /**
     * Get inquiryKey value
     * @return string|null
     */
    public function getInquiryKey()
    {
        return $this->inquiryKey;
    }
    /**
     * Set inquiryKey value
     * @param string $inquiryKey
     * @return \StructType\SyncRs
     */
    public function setInquiryKey($inquiryKey = null)
    {
        $this->inquiryKey = $inquiryKey;
        return $this;
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\SyncRs
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get origin value
     * @return \StructType\RedAddress|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \StructType\RedAddress $origin
     * @return \StructType\SyncRs
     */
    public function setOrigin(\StructType\RedAddress $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get target value
     * @return \StructType\RedAddress|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param \StructType\RedAddress $target
     * @return \StructType\SyncRs
     */
    public function setTarget(\StructType\RedAddress $target = null)
    {
        $this->target = $target;
        return $this;
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\SyncRs
     */
    public function setErrorCode($errorCode = null)
    {
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorText value
     * @return string|null
     */
    public function getErrorText()
    {
        return $this->errorText;
    }
    /**
     * Set errorText value
     * @param string $errorText
     * @return \StructType\SyncRs
     */
    public function setErrorText($errorText = null)
    {
        $this->errorText = $errorText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SyncRs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
