<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений SvedNedvDataType "Сведения о недвижимости"
 * @subpackage Structs
 */
class SvedNedvDataType extends InformationType
{
    /**
     * The NaimNedv
     * Meta informations extracted from the WSDL
     * - documentation: Наименование объекта недвижимости | Строка длиной от 1 до 4000 символов
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $NaimNedv;
    /**
     * The ObjectTypeText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание типа объекта недвижимости | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ObjectTypeText;
    /**
     * The KadastrN
     * Meta informations extracted from the WSDL
     * - documentation: Кадастровый номер | Строка длиной от 1 до 500 символов
     * - minOccurs: 0
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $KadastrN;
    /**
     * The ConditionalNumber
     * Meta informations extracted from the WSDL
     * - documentation: Условный номер | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ConditionalNumber;
    /**
     * The ObjectTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код типа объекта недвижимости | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $ObjectTypeCode;
    /**
     * The AdresNedv
     * Meta informations extracted from the WSDL
     * - documentation: Точный адрес (местоположение) | Строка длиной от 1 до 1500 символов
     * - maxLength: 1500
     * - minLength: 1
     * @var string
     */
    public $AdresNedv;
    /**
     * The AddressParts
     * Meta informations extracted from the WSDL
     * - documentation: Адрес объекта
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $AddressParts;
    /**
     * The SNedv
     * Meta informations extracted from the WSDL
     * - documentation: Площадь | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SNedv;
    /**
     * The InvNNedv
     * Meta informations extracted from the WSDL
     * - documentation: Инвентарный номер | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $InvNNedv;
    /**
     * The LiterN
     * Meta informations extracted from the WSDL
     * - documentation: Литер | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $LiterN;
    /**
     * The Floor
     * Meta informations extracted from the WSDL
     * - documentation: Этаж | Строка длиной от 1 до 3 символов
     * - minOccurs: 0
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $Floor;
    /**
     * The Nfloor
     * Meta informations extracted from the WSDL
     * - documentation: Номер на поэтажном плане | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Nfloor;
    /**
     * The RegisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegisterDate;
    /**
     * The UnregisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчуждения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $UnregisterDate;
    /**
     * The AssignationCode
     * Meta informations extracted from the WSDL
     * - documentation: Код назначения | Строка длиной от 1 до 12 символов
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $AssignationCode;
    /**
     * The AssignationName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование назначения | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $AssignationName;
    /**
     * The AssignationText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание назначения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $AssignationText;
    /**
     * The GroundCategoryCode
     * Meta informations extracted from the WSDL
     * - documentation: Целевое назначение (категория) земель | Строка длиной от 1 до 12 символов
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $GroundCategoryCode;
    /**
     * The GroundCategoryText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание целевого назначения(категории) земель | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $GroundCategoryText;
    /**
     * The Area
     * Meta informations extracted from the WSDL
     * - documentation: Площади
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SvedNedvAreaType[]
     */
    public $Area;
    /**
     * Constructor method for SvedNedvDataType
     * @uses SvedNedvDataType::setNaimNedv()
     * @uses SvedNedvDataType::setObjectTypeText()
     * @uses SvedNedvDataType::setKadastrN()
     * @uses SvedNedvDataType::setConditionalNumber()
     * @uses SvedNedvDataType::setObjectTypeCode()
     * @uses SvedNedvDataType::setAdresNedv()
     * @uses SvedNedvDataType::setAddressParts()
     * @uses SvedNedvDataType::setSNedv()
     * @uses SvedNedvDataType::setInvNNedv()
     * @uses SvedNedvDataType::setLiterN()
     * @uses SvedNedvDataType::setFloor()
     * @uses SvedNedvDataType::setNfloor()
     * @uses SvedNedvDataType::setRegisterDate()
     * @uses SvedNedvDataType::setUnregisterDate()
     * @uses SvedNedvDataType::setAssignationCode()
     * @uses SvedNedvDataType::setAssignationName()
     * @uses SvedNedvDataType::setAssignationText()
     * @uses SvedNedvDataType::setGroundCategoryCode()
     * @uses SvedNedvDataType::setGroundCategoryText()
     * @uses SvedNedvDataType::setArea()
     * @param string $naimNedv
     * @param string $objectTypeText
     * @param string $kadastrN
     * @param string $conditionalNumber
     * @param string $objectTypeCode
     * @param string $adresNedv
     * @param \StructType\AddressType $addressParts
     * @param float $sNedv
     * @param string $invNNedv
     * @param string $literN
     * @param string $floor
     * @param string $nfloor
     * @param string $registerDate
     * @param string $unregisterDate
     * @param string $assignationCode
     * @param string $assignationName
     * @param string $assignationText
     * @param string $groundCategoryCode
     * @param string $groundCategoryText
     * @param \StructType\SvedNedvAreaType[] $area
     */
    public function __construct($naimNedv = null, $objectTypeText = null, $kadastrN = null, $conditionalNumber = null, $objectTypeCode = null, $adresNedv = null, \StructType\AddressType $addressParts = null, $sNedv = null, $invNNedv = null, $literN = null, $floor = null, $nfloor = null, $registerDate = null, $unregisterDate = null, $assignationCode = null, $assignationName = null, $assignationText = null, $groundCategoryCode = null, $groundCategoryText = null, array $area = array())
    {
        $this
            ->setNaimNedv($naimNedv)
            ->setObjectTypeText($objectTypeText)
            ->setKadastrN($kadastrN)
            ->setConditionalNumber($conditionalNumber)
            ->setObjectTypeCode($objectTypeCode)
            ->setAdresNedv($adresNedv)
            ->setAddressParts($addressParts)
            ->setSNedv($sNedv)
            ->setInvNNedv($invNNedv)
            ->setLiterN($literN)
            ->setFloor($floor)
            ->setNfloor($nfloor)
            ->setRegisterDate($registerDate)
            ->setUnregisterDate($unregisterDate)
            ->setAssignationCode($assignationCode)
            ->setAssignationName($assignationName)
            ->setAssignationText($assignationText)
            ->setGroundCategoryCode($groundCategoryCode)
            ->setGroundCategoryText($groundCategoryText)
            ->setArea($area);
    }
    /**
     * Get NaimNedv value
     * @return string|null
     */
    public function getNaimNedv()
    {
        return $this->NaimNedv;
    }
    /**
     * Set NaimNedv value
     * @param string $naimNedv
     * @return \StructType\SvedNedvDataType
     */
    public function setNaimNedv($naimNedv = null)
    {
        $this->NaimNedv = $naimNedv;
        return $this;
    }
    /**
     * Get ObjectTypeText value
     * @return string|null
     */
    public function getObjectTypeText()
    {
        return $this->ObjectTypeText;
    }
    /**
     * Set ObjectTypeText value
     * @param string $objectTypeText
     * @return \StructType\SvedNedvDataType
     */
    public function setObjectTypeText($objectTypeText = null)
    {
        $this->ObjectTypeText = $objectTypeText;
        return $this;
    }
    /**
     * Get KadastrN value
     * @return string|null
     */
    public function getKadastrN()
    {
        return $this->KadastrN;
    }
    /**
     * Set KadastrN value
     * @param string $kadastrN
     * @return \StructType\SvedNedvDataType
     */
    public function setKadastrN($kadastrN = null)
    {
        $this->KadastrN = $kadastrN;
        return $this;
    }
    /**
     * Get ConditionalNumber value
     * @return string|null
     */
    public function getConditionalNumber()
    {
        return $this->ConditionalNumber;
    }
    /**
     * Set ConditionalNumber value
     * @param string $conditionalNumber
     * @return \StructType\SvedNedvDataType
     */
    public function setConditionalNumber($conditionalNumber = null)
    {
        $this->ConditionalNumber = $conditionalNumber;
        return $this;
    }
    /**
     * Get ObjectTypeCode value
     * @return string|null
     */
    public function getObjectTypeCode()
    {
        return $this->ObjectTypeCode;
    }
    /**
     * Set ObjectTypeCode value
     * @param string $objectTypeCode
     * @return \StructType\SvedNedvDataType
     */
    public function setObjectTypeCode($objectTypeCode = null)
    {
        $this->ObjectTypeCode = $objectTypeCode;
        return $this;
    }
    /**
     * Get AdresNedv value
     * @return string|null
     */
    public function getAdresNedv()
    {
        return $this->AdresNedv;
    }
    /**
     * Set AdresNedv value
     * @param string $adresNedv
     * @return \StructType\SvedNedvDataType
     */
    public function setAdresNedv($adresNedv = null)
    {
        $this->AdresNedv = $adresNedv;
        return $this;
    }
    /**
     * Get AddressParts value
     * @return \StructType\AddressType|null
     */
    public function getAddressParts()
    {
        return $this->AddressParts;
    }
    /**
     * Set AddressParts value
     * @param \StructType\AddressType $addressParts
     * @return \StructType\SvedNedvDataType
     */
    public function setAddressParts(\StructType\AddressType $addressParts = null)
    {
        $this->AddressParts = $addressParts;
        return $this;
    }
    /**
     * Get SNedv value
     * @return float|null
     */
    public function getSNedv()
    {
        return $this->SNedv;
    }
    /**
     * Set SNedv value
     * @param float $sNedv
     * @return \StructType\SvedNedvDataType
     */
    public function setSNedv($sNedv = null)
    {
        $this->SNedv = $sNedv;
        return $this;
    }
    /**
     * Get InvNNedv value
     * @return string|null
     */
    public function getInvNNedv()
    {
        return $this->InvNNedv;
    }
    /**
     * Set InvNNedv value
     * @param string $invNNedv
     * @return \StructType\SvedNedvDataType
     */
    public function setInvNNedv($invNNedv = null)
    {
        $this->InvNNedv = $invNNedv;
        return $this;
    }
    /**
     * Get LiterN value
     * @return string|null
     */
    public function getLiterN()
    {
        return $this->LiterN;
    }
    /**
     * Set LiterN value
     * @param string $literN
     * @return \StructType\SvedNedvDataType
     */
    public function setLiterN($literN = null)
    {
        $this->LiterN = $literN;
        return $this;
    }
    /**
     * Get Floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->Floor;
    }
    /**
     * Set Floor value
     * @param string $floor
     * @return \StructType\SvedNedvDataType
     */
    public function setFloor($floor = null)
    {
        $this->Floor = $floor;
        return $this;
    }
    /**
     * Get Nfloor value
     * @return string|null
     */
    public function getNfloor()
    {
        return $this->Nfloor;
    }
    /**
     * Set Nfloor value
     * @param string $nfloor
     * @return \StructType\SvedNedvDataType
     */
    public function setNfloor($nfloor = null)
    {
        $this->Nfloor = $nfloor;
        return $this;
    }
    /**
     * Get RegisterDate value
     * @return string|null
     */
    public function getRegisterDate()
    {
        return $this->RegisterDate;
    }
    /**
     * Set RegisterDate value
     * @param string $registerDate
     * @return \StructType\SvedNedvDataType
     */
    public function setRegisterDate($registerDate = null)
    {
        $this->RegisterDate = $registerDate;
        return $this;
    }
    /**
     * Get UnregisterDate value
     * @return string|null
     */
    public function getUnregisterDate()
    {
        return $this->UnregisterDate;
    }
    /**
     * Set UnregisterDate value
     * @param string $unregisterDate
     * @return \StructType\SvedNedvDataType
     */
    public function setUnregisterDate($unregisterDate = null)
    {
        $this->UnregisterDate = $unregisterDate;
        return $this;
    }
    /**
     * Get AssignationCode value
     * @return string|null
     */
    public function getAssignationCode()
    {
        return $this->AssignationCode;
    }
    /**
     * Set AssignationCode value
     * @param string $assignationCode
     * @return \StructType\SvedNedvDataType
     */
    public function setAssignationCode($assignationCode = null)
    {
        $this->AssignationCode = $assignationCode;
        return $this;
    }
    /**
     * Get AssignationName value
     * @return string|null
     */
    public function getAssignationName()
    {
        return $this->AssignationName;
    }
    /**
     * Set AssignationName value
     * @param string $assignationName
     * @return \StructType\SvedNedvDataType
     */
    public function setAssignationName($assignationName = null)
    {
        $this->AssignationName = $assignationName;
        return $this;
    }
    /**
     * Get AssignationText value
     * @return string|null
     */
    public function getAssignationText()
    {
        return $this->AssignationText;
    }
    /**
     * Set AssignationText value
     * @param string $assignationText
     * @return \StructType\SvedNedvDataType
     */
    public function setAssignationText($assignationText = null)
    {
        $this->AssignationText = $assignationText;
        return $this;
    }
    /**
     * Get GroundCategoryCode value
     * @return string|null
     */
    public function getGroundCategoryCode()
    {
        return $this->GroundCategoryCode;
    }
    /**
     * Set GroundCategoryCode value
     * @param string $groundCategoryCode
     * @return \StructType\SvedNedvDataType
     */
    public function setGroundCategoryCode($groundCategoryCode = null)
    {
        $this->GroundCategoryCode = $groundCategoryCode;
        return $this;
    }
    /**
     * Get GroundCategoryText value
     * @return string|null
     */
    public function getGroundCategoryText()
    {
        return $this->GroundCategoryText;
    }
    /**
     * Set GroundCategoryText value
     * @param string $groundCategoryText
     * @return \StructType\SvedNedvDataType
     */
    public function setGroundCategoryText($groundCategoryText = null)
    {
        $this->GroundCategoryText = $groundCategoryText;
        return $this;
    }
    /**
     * Get Area value
     * @return \StructType\SvedNedvAreaType[]|null
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * Set Area value
     * @throws \InvalidArgumentException
     * @param \StructType\SvedNedvAreaType[] $area
     * @return \StructType\SvedNedvDataType
     */
    public function setArea(array $area = array())
    {
        $this->Area = $area;
        return $this;
    }
    /**
     * Add item to Area value
     * @throws \InvalidArgumentException
     * @param \StructType\SvedNedvAreaType $item
     * @return \StructType\SvedNedvDataType
     */
    public function addToArea(\StructType\SvedNedvAreaType $item)
    {
        $this->Area[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SvedNedvDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
