<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvAreaType StructType
 * @subpackage Structs
 */
class SvedNedvAreaType extends AbstractStructBase
{
    /**
     * The areaCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида площади | Строка длиной от 1 до 3 символов
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $areaCode;
    /**
     * The areaName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида площади по справочнику | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $areaName;
    /**
     * The areaText
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое описание вида площади по справочнику | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $areaText;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - documentation: Значение площади | Площадь
     * - fractionDigits: 2
     * - totalDigits: 20
     * @var float
     */
    public $value;
    /**
     * The unitCode
     * Meta informations extracted from the WSDL
     * - documentation: Единица измерений | Код ОКЕИ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $unitCode;
    /**
     * The unitName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование единицы измерения | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $unitName;
    /**
     * Constructor method for SvedNedvAreaType
     * @uses SvedNedvAreaType::setAreaCode()
     * @uses SvedNedvAreaType::setAreaName()
     * @uses SvedNedvAreaType::setAreaText()
     * @uses SvedNedvAreaType::setValue()
     * @uses SvedNedvAreaType::setUnitCode()
     * @uses SvedNedvAreaType::setUnitName()
     * @param string $areaCode
     * @param string $areaName
     * @param string $areaText
     * @param float $value
     * @param string $unitCode
     * @param string $unitName
     */
    public function __construct($areaCode = null, $areaName = null, $areaText = null, $value = null, $unitCode = null, $unitName = null)
    {
        $this
            ->setAreaCode($areaCode)
            ->setAreaName($areaName)
            ->setAreaText($areaText)
            ->setValue($value)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName);
    }
    /**
     * Get areaCode value
     * @return string|null
     */
    public function getAreaCode()
    {
        return $this->areaCode;
    }
    /**
     * Set areaCode value
     * @param string $areaCode
     * @return \StructType\SvedNedvAreaType
     */
    public function setAreaCode($areaCode = null)
    {
        $this->areaCode = $areaCode;
        return $this;
    }
    /**
     * Get areaName value
     * @return string|null
     */
    public function getAreaName()
    {
        return $this->areaName;
    }
    /**
     * Set areaName value
     * @param string $areaName
     * @return \StructType\SvedNedvAreaType
     */
    public function setAreaName($areaName = null)
    {
        $this->areaName = $areaName;
        return $this;
    }
    /**
     * Get areaText value
     * @return string|null
     */
    public function getAreaText()
    {
        return $this->areaText;
    }
    /**
     * Set areaText value
     * @param string $areaText
     * @return \StructType\SvedNedvAreaType
     */
    public function setAreaText($areaText = null)
    {
        $this->areaText = $areaText;
        return $this;
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\SvedNedvAreaType
     */
    public function setValue($value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Get unitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->unitCode;
    }
    /**
     * Set unitCode value
     * @param string $unitCode
     * @return \StructType\SvedNedvAreaType
     */
    public function setUnitCode($unitCode = null)
    {
        $this->unitCode = $unitCode;
        return $this;
    }
    /**
     * Get unitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->unitName;
    }
    /**
     * Set unitName value
     * @param string $unitName
     * @return \StructType\SvedNedvAreaType
     */
    public function setUnitName($unitName = null)
    {
        $this->unitName = $unitName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SvedNedvAreaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
