<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignaturePropertiesType StructType
 * @subpackage Structs
 */
class SignaturePropertiesType extends AbstractStructBase
{
    /**
     * The SignatureProperty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:SignatureProperty
     * @var \StructType\SignaturePropertyType[]
     */
    public $SignatureProperty;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignaturePropertiesType
     * @uses SignaturePropertiesType::setSignatureProperty()
     * @uses SignaturePropertiesType::setId()
     * @param \StructType\SignaturePropertyType[] $signatureProperty
     * @param string $id
     */
    public function __construct(array $signatureProperty = array(), $id = null)
    {
        $this
            ->setSignatureProperty($signatureProperty)
            ->setId($id);
    }
    /**
     * Get SignatureProperty value
     * @return \StructType\SignaturePropertyType[]|null
     */
    public function getSignatureProperty()
    {
        return $this->SignatureProperty;
    }
    /**
     * Set SignatureProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\SignaturePropertyType[] $signatureProperty
     * @return \StructType\SignaturePropertiesType
     */
    public function setSignatureProperty(array $signatureProperty = array())
    {
        $this->SignatureProperty = $signatureProperty;
        return $this;
    }
    /**
     * Add item to SignatureProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\SignaturePropertyType $item
     * @return \StructType\SignaturePropertiesType
     */
    public function addToSignatureProperty(\StructType\SignaturePropertyType $item)
    {
        $this->SignatureProperty[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\SignaturePropertiesType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignaturePropertiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
