<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShareType StructType
 * @subpackage Structs
 */
class ShareType extends AbstractStructBase
{
    /**
     * The numerator
     * Meta informations extracted from the WSDL
     * - documentation: Числитель
     * - minOccurs: 0
     * @var int
     */
    public $numerator;
    /**
     * The denominator
     * Meta informations extracted from the WSDL
     * - documentation: Знаменатель
     * - minOccurs: 0
     * @var int
     */
    public $denominator;
    /**
     * Constructor method for ShareType
     * @uses ShareType::setNumerator()
     * @uses ShareType::setDenominator()
     * @param int $numerator
     * @param int $denominator
     */
    public function __construct($numerator = null, $denominator = null)
    {
        $this
            ->setNumerator($numerator)
            ->setDenominator($denominator);
    }
    /**
     * Get numerator value
     * @return int|null
     */
    public function getNumerator()
    {
        return $this->numerator;
    }
    /**
     * Set numerator value
     * @param int $numerator
     * @return \StructType\ShareType
     */
    public function setNumerator($numerator = null)
    {
        $this->numerator = $numerator;
        return $this;
    }
    /**
     * Get denominator value
     * @return int|null
     */
    public function getDenominator()
    {
        return $this->denominator;
    }
    /**
     * Set denominator value
     * @param int $denominator
     * @return \StructType\ShareType
     */
    public function setDenominator($denominator = null)
    {
        $this->denominator = $denominator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
