<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SentencedPersonNoImprisonmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об отбывании осужденным должником наказания, не связанного с лишением свободы
 * @subpackage Structs
 */
class SentencedPersonNoImprisonmentType extends InformationType
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановки на учет | Дата | Дата
     * - minOccurs: 1
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $StartDate;
    /**
     * The FinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата снятия с учета | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $FinDate;
    /**
     * The GroundDeregistration
     * Meta informations extracted from the WSDL
     * - documentation: Основание снятия с учета | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $GroundDeregistration;
    /**
     * Constructor method for SentencedPersonNoImprisonmentType
     * @uses SentencedPersonNoImprisonmentType::setStartDate()
     * @uses SentencedPersonNoImprisonmentType::setFinDate()
     * @uses SentencedPersonNoImprisonmentType::setGroundDeregistration()
     * @param string $startDate
     * @param string $finDate
     * @param string $groundDeregistration
     */
    public function __construct($startDate = null, $finDate = null, $groundDeregistration = null)
    {
        $this
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setGroundDeregistration($groundDeregistration);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\SentencedPersonNoImprisonmentType
     */
    public function setStartDate($startDate = null)
    {
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get FinDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->FinDate;
    }
    /**
     * Set FinDate value
     * @param string $finDate
     * @return \StructType\SentencedPersonNoImprisonmentType
     */
    public function setFinDate($finDate = null)
    {
        $this->FinDate = $finDate;
        return $this;
    }
    /**
     * Get GroundDeregistration value
     * @return string|null
     */
    public function getGroundDeregistration()
    {
        return $this->GroundDeregistration;
    }
    /**
     * Set GroundDeregistration value
     * @param string $groundDeregistration
     * @return \StructType\SentencedPersonNoImprisonmentType
     */
    public function setGroundDeregistration($groundDeregistration = null)
    {
        $this->GroundDeregistration = $groundDeregistration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SentencedPersonNoImprisonmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
