<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SentencedPersonImprisonmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об отбывании наказания осужденным должником в местах лишения свободы
 * @subpackage Structs
 */
class SentencedPersonImprisonmentType extends InformationType
{
    /**
     * The DatePunishment
     * Meta informations extracted from the WSDL
     * - documentation: Срок (дата) отбывания наказания | Дата | Дата
     * - minOccurs: 1
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DatePunishment;
    /**
     * The FactEmployment
     * Meta informations extracted from the WSDL
     * - documentation: Факт трудоустройства по месту отбывания наказания | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $FactEmployment;
    /**
     * The PersonalAccConvict
     * Meta informations extracted from the WSDL
     * - documentation: Номер лицевого счета осужденного должника | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PersonalAccConvict;
    /**
     * The SumPersonalAccConvict
     * Meta informations extracted from the WSDL
     * - documentation: Сумма денежных средств на лицевом счете осужденного должника | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SumPersonalAccConvict;
    /**
     * The DateGrantParole
     * Meta informations extracted from the WSDL
     * - documentation: Дата возможного рассмотрения вопроса об условно-досрочном освобождении | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateGrantParole;
    /**
     * The AdrPunishment
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места отбывания наказания | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AdrPunishment;
    /**
     * Constructor method for SentencedPersonImprisonmentType
     * @uses SentencedPersonImprisonmentType::setDatePunishment()
     * @uses SentencedPersonImprisonmentType::setFactEmployment()
     * @uses SentencedPersonImprisonmentType::setPersonalAccConvict()
     * @uses SentencedPersonImprisonmentType::setSumPersonalAccConvict()
     * @uses SentencedPersonImprisonmentType::setDateGrantParole()
     * @uses SentencedPersonImprisonmentType::setAdrPunishment()
     * @param string $datePunishment
     * @param string $factEmployment
     * @param string $personalAccConvict
     * @param float $sumPersonalAccConvict
     * @param string $dateGrantParole
     * @param string $adrPunishment
     */
    public function __construct($datePunishment = null, $factEmployment = null, $personalAccConvict = null, $sumPersonalAccConvict = null, $dateGrantParole = null, $adrPunishment = null)
    {
        $this
            ->setDatePunishment($datePunishment)
            ->setFactEmployment($factEmployment)
            ->setPersonalAccConvict($personalAccConvict)
            ->setSumPersonalAccConvict($sumPersonalAccConvict)
            ->setDateGrantParole($dateGrantParole)
            ->setAdrPunishment($adrPunishment);
    }
    /**
     * Get DatePunishment value
     * @return string
     */
    public function getDatePunishment()
    {
        return $this->DatePunishment;
    }
    /**
     * Set DatePunishment value
     * @param string $datePunishment
     * @return \StructType\SentencedPersonImprisonmentType
     */
    public function setDatePunishment($datePunishment = null)
    {
        $this->DatePunishment = $datePunishment;
        return $this;
    }
    /**
     * Get FactEmployment value
     * @return string|null
     */
    public function getFactEmployment()
    {
        return $this->FactEmployment;
    }
    /**
     * Set FactEmployment value
     * @param string $factEmployment
     * @return \StructType\SentencedPersonImprisonmentType
     */
    public function setFactEmployment($factEmployment = null)
    {
        $this->FactEmployment = $factEmployment;
        return $this;
    }
    /**
     * Get PersonalAccConvict value
     * @return string|null
     */
    public function getPersonalAccConvict()
    {
        return $this->PersonalAccConvict;
    }
    /**
     * Set PersonalAccConvict value
     * @param string $personalAccConvict
     * @return \StructType\SentencedPersonImprisonmentType
     */
    public function setPersonalAccConvict($personalAccConvict = null)
    {
        $this->PersonalAccConvict = $personalAccConvict;
        return $this;
    }
    /**
     * Get SumPersonalAccConvict value
     * @return float|null
     */
    public function getSumPersonalAccConvict()
    {
        return $this->SumPersonalAccConvict;
    }
    /**
     * Set SumPersonalAccConvict value
     * @param float $sumPersonalAccConvict
     * @return \StructType\SentencedPersonImprisonmentType
     */
    public function setSumPersonalAccConvict($sumPersonalAccConvict = null)
    {
        $this->SumPersonalAccConvict = $sumPersonalAccConvict;
        return $this;
    }
    /**
     * Get DateGrantParole value
     * @return string|null
     */
    public function getDateGrantParole()
    {
        return $this->DateGrantParole;
    }
    /**
     * Set DateGrantParole value
     * @param string $dateGrantParole
     * @return \StructType\SentencedPersonImprisonmentType
     */
    public function setDateGrantParole($dateGrantParole = null)
    {
        $this->DateGrantParole = $dateGrantParole;
        return $this;
    }
    /**
     * Get AdrPunishment value
     * @return string|null
     */
    public function getAdrPunishment()
    {
        return $this->AdrPunishment;
    }
    /**
     * Set AdrPunishment value
     * @param string $adrPunishment
     * @return \StructType\SentencedPersonImprisonmentType
     */
    public function setAdrPunishment($adrPunishment = null)
    {
        $this->AdrPunishment = $adrPunishment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SentencedPersonImprisonmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
