<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SenderSPIType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реквизиты отправителя документа-СПИ | Используется для передачи сведений об отделе судебных приставов и должностном лице,
 * направившем документ в адрес внешнего контрагента
 * @subpackage Structs
 */
class SenderSPIType extends AbstractStructBase
{
    /**
     * The SPIKey
     * Meta informations extracted from the WSDL
     * - documentation: Код должностного лица сделавшего заявление | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта
     * или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPIKey;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица сделавшего заявление | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIFioParts
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица сделавшего заявление | Заполняется, если соответствующие данные есть в системе. Для запросов к
     * операторам сотовой связи обязательно
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $SPIFioParts;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон должностного лица сделавшего заявление | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности должностного лица, сделавшего заявления | Заполняется по справочнику должностей ФССП России на основе ОКПДТР /
     * РДФГГС | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * Constructor method for SenderSPIType
     * @uses SenderSPIType::setSPIKey()
     * @uses SenderSPIType::setSPIFio()
     * @uses SenderSPIType::setSPIFioParts()
     * @uses SenderSPIType::setSPITel()
     * @uses SenderSPIType::setSPIPost()
     * @param int $sPIKey
     * @param string $sPIFio
     * @param \StructType\FioType $sPIFioParts
     * @param string $sPITel
     * @param string $sPIPost
     */
    public function __construct($sPIKey = null, $sPIFio = null, \StructType\FioType $sPIFioParts = null, $sPITel = null, $sPIPost = null)
    {
        $this
            ->setSPIKey($sPIKey)
            ->setSPIFio($sPIFio)
            ->setSPIFioParts($sPIFioParts)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost);
    }
    /**
     * Get SPIKey value
     * @return int|null
     */
    public function getSPIKey()
    {
        return $this->SPIKey;
    }
    /**
     * Set SPIKey value
     * @param int $sPIKey
     * @return \StructType\SenderSPIType
     */
    public function setSPIKey($sPIKey = null)
    {
        $this->SPIKey = $sPIKey;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\SenderSPIType
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIFioParts value
     * @return \StructType\FioType|null
     */
    public function getSPIFioParts()
    {
        return $this->SPIFioParts;
    }
    /**
     * Set SPIFioParts value
     * @param \StructType\FioType $sPIFioParts
     * @return \StructType\SenderSPIType
     */
    public function setSPIFioParts(\StructType\FioType $sPIFioParts = null)
    {
        $this->SPIFioParts = $sPIFioParts;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \StructType\SenderSPIType
     */
    public function setSPITel($sPITel = null)
    {
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \StructType\SenderSPIType
     */
    public function setSPIPost($sPIPost = null)
    {
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SenderSPIType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
