<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SenderContragentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реквизиты отправителя документа—внешнего контрагента | используется для передачи сведений об организации и лице,
 * направившем юридически значимый документ в адрес ФССП России
 * @subpackage Structs
 */
class SenderContragentType extends AbstractStructBase
{
    /**
     * The AuthorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | ФИО должностного лица, от имени которого направлен судебный акт, определение | Полное имя физического
     * лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $AuthorName;
    /**
     * The AuthorPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Наименование должности | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $AuthorPost;
    /**
     * The AuthorEmail
     * Meta informations extracted from the WSDL
     * - documentation: Электропочта | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $AuthorEmail;
    /**
     * The AuthorTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $AuthorTelephone;
    /**
     * Constructor method for SenderContragentType
     * @uses SenderContragentType::setAuthorName()
     * @uses SenderContragentType::setAuthorPost()
     * @uses SenderContragentType::setAuthorEmail()
     * @uses SenderContragentType::setAuthorTelephone()
     * @param string $authorName
     * @param string $authorPost
     * @param string $authorEmail
     * @param string $authorTelephone
     */
    public function __construct($authorName = null, $authorPost = null, $authorEmail = null, $authorTelephone = null)
    {
        $this
            ->setAuthorName($authorName)
            ->setAuthorPost($authorPost)
            ->setAuthorEmail($authorEmail)
            ->setAuthorTelephone($authorTelephone);
    }
    /**
     * Get AuthorName value
     * @return string|null
     */
    public function getAuthorName()
    {
        return $this->AuthorName;
    }
    /**
     * Set AuthorName value
     * @param string $authorName
     * @return \StructType\SenderContragentType
     */
    public function setAuthorName($authorName = null)
    {
        $this->AuthorName = $authorName;
        return $this;
    }
    /**
     * Get AuthorPost value
     * @return string|null
     */
    public function getAuthorPost()
    {
        return $this->AuthorPost;
    }
    /**
     * Set AuthorPost value
     * @param string $authorPost
     * @return \StructType\SenderContragentType
     */
    public function setAuthorPost($authorPost = null)
    {
        $this->AuthorPost = $authorPost;
        return $this;
    }
    /**
     * Get AuthorEmail value
     * @return string|null
     */
    public function getAuthorEmail()
    {
        return $this->AuthorEmail;
    }
    /**
     * Set AuthorEmail value
     * @param string $authorEmail
     * @return \StructType\SenderContragentType
     */
    public function setAuthorEmail($authorEmail = null)
    {
        $this->AuthorEmail = $authorEmail;
        return $this;
    }
    /**
     * Get AuthorTelephone value
     * @return string|null
     */
    public function getAuthorTelephone()
    {
        return $this->AuthorTelephone;
    }
    /**
     * Set AuthorTelephone value
     * @param string $authorTelephone
     * @return \StructType\SenderContragentType
     */
    public function setAuthorTelephone($authorTelephone = null)
    {
        $this->AuthorTelephone = $authorTelephone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SenderContragentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
