<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на запрос (абстрактный)
 * @subpackage Structs
 */
abstract class Response extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ответа на запрос АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * Constructor method for Response
     * @uses Response::setInternalKey()
     * @uses Response::setRequestKey()
     * @param int $internalKey
     * @param string $requestKey
     */
    public function __construct($internalKey = null, $requestKey = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestKey($requestKey);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\Response
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \StructType\Response
     */
    public function setRequestKey($requestKey = null)
    {
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
