<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistryFileRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос реестров и справочников ФССП России
 * - type: tns:RegistryFileRequest
 * @subpackage Structs
 */
class RegistryFileRequest extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время запроса | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - documentation: Тип справочника
     * @var string
     */
    public $TypeDoc;
    /**
     * The IsUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Признак запроса обновления | В случае, если передается false – контрагент запрашивает полный реестр, если true — только изменения. |
     * Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsUpdate;
    /**
     * Constructor method for RegistryFileRequest
     * @uses RegistryFileRequest::setExternalKey()
     * @uses RegistryFileRequest::setUnloadDate()
     * @uses RegistryFileRequest::setTypeDoc()
     * @uses RegistryFileRequest::setIsUpdate()
     * @param string $externalKey
     * @param string $unloadDate
     * @param string $typeDoc
     * @param bool $isUpdate
     */
    public function __construct($externalKey = null, $unloadDate = null, $typeDoc = null, $isUpdate = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setUnloadDate($unloadDate)
            ->setTypeDoc($typeDoc)
            ->setIsUpdate($isUpdate);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\RegistryFileRequest
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \StructType\RegistryFileRequest
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @uses \EnumType\RegistryDocType::valueIsValid()
     * @uses \EnumType\RegistryDocType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeDoc
     * @return \StructType\RegistryFileRequest
     */
    public function setTypeDoc($typeDoc = null)
    {
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get IsUpdate value
     * @return bool|null
     */
    public function getIsUpdate()
    {
        return $this->IsUpdate;
    }
    /**
     * Set IsUpdate value
     * @param bool $isUpdate
     * @return \StructType\RegistryFileRequest
     */
    public function setIsUpdate($isUpdate = null)
    {
        $this->IsUpdate = $isUpdate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegistryFileRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
