<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistrationDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о регистрации
 * @subpackage Structs
 */
class RegistrationDatumType extends InformationType
{
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановки на учет | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $startDate;
    /**
     * The finDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата снятия с учета | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finDate;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер | Строка длиной от 1 до 30 символов
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $regNumber;
    /**
     * Constructor method for RegistrationDatumType
     * @uses RegistrationDatumType::setStartDate()
     * @uses RegistrationDatumType::setFinDate()
     * @uses RegistrationDatumType::setRegNumber()
     * @param string $startDate
     * @param string $finDate
     * @param string $regNumber
     */
    public function __construct($startDate = null, $finDate = null, $regNumber = null)
    {
        $this
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setRegNumber($regNumber);
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\RegistrationDatumType
     */
    public function setStartDate($startDate = null)
    {
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get finDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->finDate;
    }
    /**
     * Set finDate value
     * @param string $finDate
     * @return \StructType\RegistrationDatumType
     */
    public function setFinDate($finDate = null)
    {
        $this->finDate = $finDate;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \StructType\RegistrationDatumType
     */
    public function setRegNumber($regNumber = null)
    {
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegistrationDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
