<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос информации справочника
 * - type: tns:ReferenceInfo
 * @subpackage Structs
 */
class ReferenceInfo extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта, присвоенный АИС ФССП России. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании
     * объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The requestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса списка реквизитов ОСП, полученный ранее от АИС внешнего контрагента. | Идентификатор объекта,
     * присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestExternalKey;
    /**
     * The referenceData
     * Meta informations extracted from the WSDL
     * - documentation: Код вида справочника
     * @var \StructType\ReferenceDataType
     */
    public $referenceData;
    /**
     * Constructor method for ReferenceInfo
     * @uses ReferenceInfo::setInternalKey()
     * @uses ReferenceInfo::setRequestExternalKey()
     * @uses ReferenceInfo::setReferenceData()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param \StructType\ReferenceDataType $referenceData
     */
    public function __construct($internalKey = null, $requestExternalKey = null, \StructType\ReferenceDataType $referenceData = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setReferenceData($referenceData);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\ReferenceInfo
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get requestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->requestExternalKey;
    }
    /**
     * Set requestExternalKey value
     * @param string $requestExternalKey
     * @return \StructType\ReferenceInfo
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        $this->requestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get referenceData value
     * @return \StructType\ReferenceDataType|null
     */
    public function getReferenceData()
    {
        return $this->referenceData;
    }
    /**
     * Set referenceData value
     * @param \StructType\ReferenceDataType $referenceData
     * @return \StructType\ReferenceInfo
     */
    public function setReferenceData(\StructType\ReferenceDataType $referenceData = null)
    {
        $this->referenceData = $referenceData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
