<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedAddress StructType
 * Meta informations extracted from the WSDL
 * - documentation: Адрес в формате "Ред Софт" | Адрес в формате "Ред Софт"
 * @subpackage Structs
 */
class RedAddress extends AbstractStructBase
{
    /**
     * The Org
     * Meta informations extracted from the WSDL
     * - documentation: Код организации | Код организации межведомственного обмена
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Org;
    /**
     * The Dept
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Код подразделения организации межведомственного обмена
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $Dept;
    /**
     * The OrganizationCode
     * Meta informations extracted from the WSDL
     * - documentation: Код организации | Код организации | NSI_MVV_Organization
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $OrganizationCode;
    /**
     * The DepartmentCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $DepartmentCode;
    /**
     * The Protocol
     * Meta informations extracted from the WSDL
     * - documentation: Код соглашения (протокола обмена данными) | Для данной версии протокола значение «общее_0.5» и «МВВ_ТРАНЗИТ_2.0». | Код соглашения
     * (протокола)
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Protocol;
    /**
     * Constructor method for RedAddress
     * @uses RedAddress::setOrg()
     * @uses RedAddress::setDept()
     * @uses RedAddress::setOrganizationCode()
     * @uses RedAddress::setDepartmentCode()
     * @uses RedAddress::setProtocol()
     * @param string $org
     * @param string $dept
     * @param string $organizationCode
     * @param string $departmentCode
     * @param string $protocol
     */
    public function __construct($org = null, $dept = null, $organizationCode = null, $departmentCode = null, $protocol = null)
    {
        $this
            ->setOrg($org)
            ->setDept($dept)
            ->setOrganizationCode($organizationCode)
            ->setDepartmentCode($departmentCode)
            ->setProtocol($protocol);
    }
    /**
     * Get Org value
     * @return string|null
     */
    public function getOrg()
    {
        return $this->Org;
    }
    /**
     * Set Org value
     * @param string $org
     * @return \StructType\RedAddress
     */
    public function setOrg($org = null)
    {
        $this->Org = $org;
        return $this;
    }
    /**
     * Get Dept value
     * @return string|null
     */
    public function getDept()
    {
        return $this->Dept;
    }
    /**
     * Set Dept value
     * @param string $dept
     * @return \StructType\RedAddress
     */
    public function setDept($dept = null)
    {
        $this->Dept = $dept;
        return $this;
    }
    /**
     * Get OrganizationCode value
     * @return string|null
     */
    public function getOrganizationCode()
    {
        return $this->OrganizationCode;
    }
    /**
     * Set OrganizationCode value
     * @param string $organizationCode
     * @return \StructType\RedAddress
     */
    public function setOrganizationCode($organizationCode = null)
    {
        $this->OrganizationCode = $organizationCode;
        return $this;
    }
    /**
     * Get DepartmentCode value
     * @return string|null
     */
    public function getDepartmentCode()
    {
        return $this->DepartmentCode;
    }
    /**
     * Set DepartmentCode value
     * @param string $departmentCode
     * @return \StructType\RedAddress
     */
    public function setDepartmentCode($departmentCode = null)
    {
        $this->DepartmentCode = $departmentCode;
        return $this;
    }
    /**
     * Get Protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->Protocol;
    }
    /**
     * Set Protocol value
     * @param string $protocol
     * @return \StructType\RedAddress
     */
    public function setProtocol($protocol = null)
    {
        $this->Protocol = $protocol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
