<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecoveredAmountType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные о взысканной сумме
 * @subpackage Structs
 */
class RecoveredAmountType extends AbstractStructBase
{
    /**
     * The YearMonth
     * Meta informations extracted from the WSDL
     * - documentation: Год и месяц | Год (выпуска, рождения и т. п.)
     * - maxInclusive: 2099-12
     * - minInclusive: 1900-01
     * @var int
     */
    public $YearMonth;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма взыскания | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for RecoveredAmountType
     * @uses RecoveredAmountType::setYearMonth()
     * @uses RecoveredAmountType::setAmount()
     * @param int $yearMonth
     * @param float $amount
     */
    public function __construct($yearMonth = null, $amount = null)
    {
        $this
            ->setYearMonth($yearMonth)
            ->setAmount($amount);
    }
    /**
     * Get YearMonth value
     * @return int|null
     */
    public function getYearMonth()
    {
        return $this->YearMonth;
    }
    /**
     * Set YearMonth value
     * @param int $yearMonth
     * @return \StructType\RecoveredAmountType
     */
    public function setYearMonth($yearMonth = null)
    {
        $this->YearMonth = $yearMonth;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\RecoveredAmountType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecoveredAmountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
