<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RealtyRegistryExtractType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Выписка из реестра недвижимости
 * @subpackage Structs
 */
class RealtyRegistryExtractType extends InformationType
{
    /**
     * The extractNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер выписки/справки/сообщения | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $extractNumber;
    /**
     * The extractDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выписки/справки/сообщения | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $extractDate;
    /**
     * The queryNumber
     * Meta informations extracted from the WSDL
     * - documentation: Hомер документа запроса | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $queryNumber;
    /**
     * The queryDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа запроса | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $queryDate;
    /**
     * The outgoingNumber
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий номер учреждения | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $outgoingNumber;
    /**
     * The outgoingDate
     * Meta informations extracted from the WSDL
     * - documentation: Исходящая дата учреждения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $outgoingDate;
    /**
     * The registrator
     * Meta informations extracted from the WSDL
     * - documentation: Регистратор, подписавший выписку(справку) | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $registrator;
    /**
     * The addInfo
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $addInfo;
    /**
     * The recipientInfo
     * Meta informations extracted from the WSDL
     * - documentation: Описание получателя информации ("выписка выдана ...") | Строка длиной от 1 до 4000 символов
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $recipientInfo;
    /**
     * The refusalCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип отказа | По классификатору «Классификатор типов отказов запросов информации ЕГРП» | Строка длиной от 1 до 3 символов
     * - minOccurs: 0
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $refusalCode;
    /**
     * The refusalName
     * Meta informations extracted from the WSDL
     * - documentation: Текст типа отказа | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $refusalName;
    /**
     * The refusalText
     * Meta informations extracted from the WSDL
     * - documentation: Текст отказа | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $refusalText;
    /**
     * The arrestInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация о зарегистрированных записей КУА | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $arrestInfo;
    /**
     * Constructor method for RealtyRegistryExtractType
     * @uses RealtyRegistryExtractType::setExtractNumber()
     * @uses RealtyRegistryExtractType::setExtractDate()
     * @uses RealtyRegistryExtractType::setQueryNumber()
     * @uses RealtyRegistryExtractType::setQueryDate()
     * @uses RealtyRegistryExtractType::setOutgoingNumber()
     * @uses RealtyRegistryExtractType::setOutgoingDate()
     * @uses RealtyRegistryExtractType::setRegistrator()
     * @uses RealtyRegistryExtractType::setAddInfo()
     * @uses RealtyRegistryExtractType::setRecipientInfo()
     * @uses RealtyRegistryExtractType::setRefusalCode()
     * @uses RealtyRegistryExtractType::setRefusalName()
     * @uses RealtyRegistryExtractType::setRefusalText()
     * @uses RealtyRegistryExtractType::setArrestInfo()
     * @param string $extractNumber
     * @param string $extractDate
     * @param string $queryNumber
     * @param string $queryDate
     * @param string $outgoingNumber
     * @param string $outgoingDate
     * @param string $registrator
     * @param string $addInfo
     * @param string $recipientInfo
     * @param string $refusalCode
     * @param string $refusalName
     * @param string $refusalText
     * @param string $arrestInfo
     */
    public function __construct($extractNumber = null, $extractDate = null, $queryNumber = null, $queryDate = null, $outgoingNumber = null, $outgoingDate = null, $registrator = null, $addInfo = null, $recipientInfo = null, $refusalCode = null, $refusalName = null, $refusalText = null, $arrestInfo = null)
    {
        $this
            ->setExtractNumber($extractNumber)
            ->setExtractDate($extractDate)
            ->setQueryNumber($queryNumber)
            ->setQueryDate($queryDate)
            ->setOutgoingNumber($outgoingNumber)
            ->setOutgoingDate($outgoingDate)
            ->setRegistrator($registrator)
            ->setAddInfo($addInfo)
            ->setRecipientInfo($recipientInfo)
            ->setRefusalCode($refusalCode)
            ->setRefusalName($refusalName)
            ->setRefusalText($refusalText)
            ->setArrestInfo($arrestInfo);
    }
    /**
     * Get extractNumber value
     * @return string|null
     */
    public function getExtractNumber()
    {
        return $this->extractNumber;
    }
    /**
     * Set extractNumber value
     * @param string $extractNumber
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setExtractNumber($extractNumber = null)
    {
        $this->extractNumber = $extractNumber;
        return $this;
    }
    /**
     * Get extractDate value
     * @return string|null
     */
    public function getExtractDate()
    {
        return $this->extractDate;
    }
    /**
     * Set extractDate value
     * @param string $extractDate
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setExtractDate($extractDate = null)
    {
        $this->extractDate = $extractDate;
        return $this;
    }
    /**
     * Get queryNumber value
     * @return string|null
     */
    public function getQueryNumber()
    {
        return $this->queryNumber;
    }
    /**
     * Set queryNumber value
     * @param string $queryNumber
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setQueryNumber($queryNumber = null)
    {
        $this->queryNumber = $queryNumber;
        return $this;
    }
    /**
     * Get queryDate value
     * @return string|null
     */
    public function getQueryDate()
    {
        return $this->queryDate;
    }
    /**
     * Set queryDate value
     * @param string $queryDate
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setQueryDate($queryDate = null)
    {
        $this->queryDate = $queryDate;
        return $this;
    }
    /**
     * Get outgoingNumber value
     * @return string|null
     */
    public function getOutgoingNumber()
    {
        return $this->outgoingNumber;
    }
    /**
     * Set outgoingNumber value
     * @param string $outgoingNumber
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setOutgoingNumber($outgoingNumber = null)
    {
        $this->outgoingNumber = $outgoingNumber;
        return $this;
    }
    /**
     * Get outgoingDate value
     * @return string|null
     */
    public function getOutgoingDate()
    {
        return $this->outgoingDate;
    }
    /**
     * Set outgoingDate value
     * @param string $outgoingDate
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setOutgoingDate($outgoingDate = null)
    {
        $this->outgoingDate = $outgoingDate;
        return $this;
    }
    /**
     * Get registrator value
     * @return string|null
     */
    public function getRegistrator()
    {
        return $this->registrator;
    }
    /**
     * Set registrator value
     * @param string $registrator
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setRegistrator($registrator = null)
    {
        $this->registrator = $registrator;
        return $this;
    }
    /**
     * Get addInfo value
     * @return string|null
     */
    public function getAddInfo()
    {
        return $this->addInfo;
    }
    /**
     * Set addInfo value
     * @param string $addInfo
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setAddInfo($addInfo = null)
    {
        $this->addInfo = $addInfo;
        return $this;
    }
    /**
     * Get recipientInfo value
     * @return string|null
     */
    public function getRecipientInfo()
    {
        return $this->recipientInfo;
    }
    /**
     * Set recipientInfo value
     * @param string $recipientInfo
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setRecipientInfo($recipientInfo = null)
    {
        $this->recipientInfo = $recipientInfo;
        return $this;
    }
    /**
     * Get refusalCode value
     * @return string|null
     */
    public function getRefusalCode()
    {
        return $this->refusalCode;
    }
    /**
     * Set refusalCode value
     * @param string $refusalCode
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setRefusalCode($refusalCode = null)
    {
        $this->refusalCode = $refusalCode;
        return $this;
    }
    /**
     * Get refusalName value
     * @return string|null
     */
    public function getRefusalName()
    {
        return $this->refusalName;
    }
    /**
     * Set refusalName value
     * @param string $refusalName
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setRefusalName($refusalName = null)
    {
        $this->refusalName = $refusalName;
        return $this;
    }
    /**
     * Get refusalText value
     * @return string|null
     */
    public function getRefusalText()
    {
        return $this->refusalText;
    }
    /**
     * Set refusalText value
     * @param string $refusalText
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setRefusalText($refusalText = null)
    {
        $this->refusalText = $refusalText;
        return $this;
    }
    /**
     * Get arrestInfo value
     * @return string|null
     */
    public function getArrestInfo()
    {
        return $this->arrestInfo;
    }
    /**
     * Set arrestInfo value
     * @param string $arrestInfo
     * @return \StructType\RealtyRegistryExtractType
     */
    public function setArrestInfo($arrestInfo = null)
    {
        $this->arrestInfo = $arrestInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RealtyRegistryExtractType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
