<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyChargesRegistry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реестр штрафов по АД
 * - type: tns:PenaltyChargesRegistry
 * @subpackage Structs
 */
class PenaltyChargesRegistry extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - documentation: Версия документа | Заполняется значением «PLTY_1_1» | Строка длиной от 1 до 8 символов
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Version;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ реестра ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The PenaltyData
     * Meta informations extracted from the WSDL
     * - documentation: Данные по штрафам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PenaltyChargesData[]
     */
    public $PenaltyData;
    /**
     * Constructor method for PenaltyChargesRegistry
     * @uses PenaltyChargesRegistry::setVersion()
     * @uses PenaltyChargesRegistry::setInternalKey()
     * @uses PenaltyChargesRegistry::setOspCode()
     * @uses PenaltyChargesRegistry::setDocDate()
     * @uses PenaltyChargesRegistry::setDocNumber()
     * @uses PenaltyChargesRegistry::setUnloadDate()
     * @uses PenaltyChargesRegistry::setPenaltyData()
     * @param string $version
     * @param int $internalKey
     * @param string $ospCode
     * @param string $docDate
     * @param string $docNumber
     * @param string $unloadDate
     * @param \StructType\PenaltyChargesData[] $penaltyData
     */
    public function __construct($version = null, $internalKey = null, $ospCode = null, $docDate = null, $docNumber = null, $unloadDate = null, array $penaltyData = array())
    {
        $this
            ->setVersion($version)
            ->setInternalKey($internalKey)
            ->setOspCode($ospCode)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setUnloadDate($unloadDate)
            ->setPenaltyData($penaltyData);
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\PenaltyChargesRegistry
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\PenaltyChargesRegistry
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \StructType\PenaltyChargesRegistry
     */
    public function setOspCode($ospCode = null)
    {
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\PenaltyChargesRegistry
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\PenaltyChargesRegistry
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \StructType\PenaltyChargesRegistry
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get PenaltyData value
     * @return \StructType\PenaltyChargesData[]|null
     */
    public function getPenaltyData()
    {
        return $this->PenaltyData;
    }
    /**
     * Set PenaltyData value
     * @throws \InvalidArgumentException
     * @param \StructType\PenaltyChargesData[] $penaltyData
     * @return \StructType\PenaltyChargesRegistry
     */
    public function setPenaltyData(array $penaltyData = array())
    {
        $this->PenaltyData = $penaltyData;
        return $this;
    }
    /**
     * Add item to PenaltyData value
     * @throws \InvalidArgumentException
     * @param \StructType\PenaltyChargesData $item
     * @return \StructType\PenaltyChargesRegistry
     */
    public function addToPenaltyData(\StructType\PenaltyChargesData $item)
    {
        $this->PenaltyData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PenaltyChargesRegistry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
