<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyChargesData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные по штрафам
 * - type: tns:PenaltyChargesData
 * @subpackage Structs
 */
class PenaltyChargesData extends AbstractStructBase
{
    /**
     * The PenaltyKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор записи | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $PenaltyKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The PerpetratorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип нарушителя
     * @var string
     */
    public $PerpetratorType;
    /**
     * The PerpetratorName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование нарушителя | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $PerpetratorName;
    /**
     * The PerpetratorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения нарушителя | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PerpetratorBirthDate;
    /**
     * The PerpetratorBirthplace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения нарушителя | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $PerpetratorBirthplace;
    /**
     * The PerpetratorSerDoc
     * Meta informations extracted from the WSDL
     * - documentation: Серия документа | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PerpetratorSerDoc;
    /**
     * The PerpetratorNumDoc
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PerpetratorNumDoc;
    /**
     * The PerpetratorSNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС нарушителя | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $PerpetratorSNILS;
    /**
     * The PerpetratorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН нарушителя | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $PerpetratorINN;
    /**
     * The PerpetratorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП нарушителя | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $PerpetratorKPP;
    /**
     * The PerpetratorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП нарушителя | Основной государственный регистрационный номер (ОГРН)/Основной государственный регистрационный
     * номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $PerpetratorOGRN;
    /**
     * The PerpetratorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес нарушителя | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $PerpetratorAdr;
    /**
     * The PerpetratorWorkplace
     * Meta informations extracted from the WSDL
     * - documentation: Организация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $PerpetratorWorkplace;
    /**
     * The PerpetratorWorkplaceINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН организации | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $PerpetratorWorkplaceINN;
    /**
     * The PerpetratorWorkplaceTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон организации | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PerpetratorWorkplaceTelephone;
    /**
     * The PerpetratorWorkplaceAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес организации | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $PerpetratorWorkplaceAddress;
    /**
     * The PenaltyNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер АД | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PenaltyNumber;
    /**
     * The PenaltyDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата АД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyDate;
    /**
     * The PenaltyRiseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рассмотрения АД | Дата рассмотрения административного дела. Для документа «Реестр штрафов по АД» версии «PLTY_1_0» поле
     * обязательное. | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyRiseDate;
    /**
     * The IPBasic
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП базового | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPBasic;
    /**
     * The PenaltyBasic
     * Meta informations extracted from the WSDL
     * - documentation: Номер базового АД | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PenaltyBasic;
    /**
     * The PenaltyIP
     * Meta informations extracted from the WSDL
     * - documentation: ИП по штрафу | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PenaltyIP;
    /**
     * The PenaltySum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма штрафа | Сумма штрафа по административному делу. Для документа «Реестр штрафов по АД» версии «PLTY_1_0» поле обязательное. |
     * Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PenaltySum;
    /**
     * The PenaltyRestTotal
     * Meta informations extracted from the WSDL
     * - documentation: Остаток штрафа | Остаток суммы штрафа по административному делу. Для документа «Реестр штрафов по АД» версии «PLTY_1_0» поле
     * обязательное. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PenaltyRestTotal;
    /**
     * The PenaltyKbk
     * Meta informations extracted from the WSDL
     * - documentation: КБК | Указывается КБК для перечисления денежных средств. Для документа «Реестр штрафов по АД» версии «PLTY_1_0» поле обязательное.
     * | Код бюджетной классификации (КБК)
     * - minOccurs: 0
     * - length: 20
     * - pattern: [0-9]{20}
     * @var string
     */
    public $PenaltyKbk;
    /**
     * The PenaltyAuthorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | ФИО должностного лица, составившего протокол об административном правонарушении. | Полное имя
     * физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $PenaltyAuthorName;
    /**
     * The PenaltyAuthorTel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон должностного лица | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PenaltyAuthorTel;
    /**
     * The IsConfidential
     * Meta informations extracted from the WSDL
     * - documentation: Признак закрытых сведений | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsConfidential;
    /**
     * The PenaltyAdmRisepristName
     * Meta informations extracted from the WSDL
     * - documentation: Должностное лицо, вынесшее постановление | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $PenaltyAdmRisepristName;
    /**
     * The PenaltyIdArtkoap
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор статьи КоАП | Идентификатор статьи КоАП. Для документа «Реестр штрафов по АД» версии «PLTY_1_1» поле обязательное. |
     * Положительное целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $PenaltyIdArtkoap;
    /**
     * The PenaltyUinCode
     * Meta informations extracted from the WSDL
     * - documentation: УИН | Код начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $PenaltyUinCode;
    /**
     * The PenaltyUip
     * Meta informations extracted from the WSDL
     * - documentation: УИП | УИП
     * - minOccurs: 0
     * - length: 25
     * @var string
     */
    public $PenaltyUip;
    /**
     * The PenaltyEssentialElements
     * Meta informations extracted from the WSDL
     * - documentation: Сущность правонарушения | Сущность правонарушения. Для документа «Реестр штрафов по АД» версии «PLTY_1_1» поле обязательное. |
     * Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $PenaltyEssentialElements;
    /**
     * The PenaltyExaminationSendDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата направления административного дела на рассмотрение | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyExaminationSendDate;
    /**
     * The PenaltyCourtName2
     * Meta informations extracted from the WSDL
     * - documentation: Место рассмотрения | Строка длиной от 0 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * @var string
     */
    public $PenaltyCourtName2;
    /**
     * The PenaltyExaminationResultCode
     * Meta informations extracted from the WSDL
     * - documentation: Результат рассмотрения (код) | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $PenaltyExaminationResultCode;
    /**
     * The PenaltyCourtAdmCancelDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отмены судом | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyCourtAdmCancelDate;
    /**
     * The PenaltyPayDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата полной оплаты штрафа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyPayDate;
    /**
     * The PenaltyNoPayIntime
     * Meta informations extracted from the WSDL
     * - documentation: Не уплачено в срок | Признак оплаты административного штрафа в срок. Для документа «Реестр штрафов по АД» версии «PLTY_1_1» поле
     * обязательное. | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $PenaltyNoPayIntime;
    /**
     * The PenaltyDate2025
     * Meta informations extracted from the WSDL
     * - documentation: Дата составления протокола по 20.25 | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyDate2025;
    /**
     * The PenaltyIdDocdate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи ИД по штрафу | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyIdDocdate;
    /**
     * The PenaltyIpRisedate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения ИП по штрафу | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyIpRisedate;
    /**
     * The PenaltyGisGmp
     * Meta informations extracted from the WSDL
     * - documentation: Оплата штрафа через ГИС ГМП | Признак оплаты штрафа через ГИС ГМП. Для документа «Реестр штрафов по АД» версии «PLTY_1_1» поле
     * обязательное. | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $PenaltyGisGmp;
    /**
     * The PenaltyPostId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор должности | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $PenaltyPostId;
    /**
     * The OffenderCitizenshipCode
     * Meta informations extracted from the WSDL
     * - documentation: Гражданство | Гражданство (код страны) нарушителя. | Код страны буквенный | Трехзначный (альфа-3) буквенный код страны мира по
     * классификатору ОКСМ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $OffenderCitizenshipCode;
    /**
     * The PenaltyHoursDaysQty
     * Meta informations extracted from the WSDL
     * - documentation: Количество суток (адм.арест)/часов (об.работы) | Положительное целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $PenaltyHoursDaysQty;
    /**
     * The AdmMakeDecisionPostId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор должности должностного лица, вынесшего постановление. | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $AdmMakeDecisionPostId;
    /**
     * Constructor method for PenaltyChargesData
     * @uses PenaltyChargesData::setPenaltyKey()
     * @uses PenaltyChargesData::setOspCode()
     * @uses PenaltyChargesData::setUnloadDate()
     * @uses PenaltyChargesData::setPerpetratorType()
     * @uses PenaltyChargesData::setPerpetratorName()
     * @uses PenaltyChargesData::setPerpetratorBirthDate()
     * @uses PenaltyChargesData::setPerpetratorBirthplace()
     * @uses PenaltyChargesData::setPerpetratorSerDoc()
     * @uses PenaltyChargesData::setPerpetratorNumDoc()
     * @uses PenaltyChargesData::setPerpetratorSNILS()
     * @uses PenaltyChargesData::setPerpetratorINN()
     * @uses PenaltyChargesData::setPerpetratorKPP()
     * @uses PenaltyChargesData::setPerpetratorOGRN()
     * @uses PenaltyChargesData::setPerpetratorAdr()
     * @uses PenaltyChargesData::setPerpetratorWorkplace()
     * @uses PenaltyChargesData::setPerpetratorWorkplaceINN()
     * @uses PenaltyChargesData::setPerpetratorWorkplaceTelephone()
     * @uses PenaltyChargesData::setPerpetratorWorkplaceAddress()
     * @uses PenaltyChargesData::setPenaltyNumber()
     * @uses PenaltyChargesData::setPenaltyDate()
     * @uses PenaltyChargesData::setPenaltyRiseDate()
     * @uses PenaltyChargesData::setIPBasic()
     * @uses PenaltyChargesData::setPenaltyBasic()
     * @uses PenaltyChargesData::setPenaltyIP()
     * @uses PenaltyChargesData::setPenaltySum()
     * @uses PenaltyChargesData::setPenaltyRestTotal()
     * @uses PenaltyChargesData::setPenaltyKbk()
     * @uses PenaltyChargesData::setPenaltyAuthorName()
     * @uses PenaltyChargesData::setPenaltyAuthorTel()
     * @uses PenaltyChargesData::setIsConfidential()
     * @uses PenaltyChargesData::setPenaltyAdmRisepristName()
     * @uses PenaltyChargesData::setPenaltyIdArtkoap()
     * @uses PenaltyChargesData::setPenaltyUinCode()
     * @uses PenaltyChargesData::setPenaltyUip()
     * @uses PenaltyChargesData::setPenaltyEssentialElements()
     * @uses PenaltyChargesData::setPenaltyExaminationSendDate()
     * @uses PenaltyChargesData::setPenaltyCourtName2()
     * @uses PenaltyChargesData::setPenaltyExaminationResultCode()
     * @uses PenaltyChargesData::setPenaltyCourtAdmCancelDate()
     * @uses PenaltyChargesData::setPenaltyPayDate()
     * @uses PenaltyChargesData::setPenaltyNoPayIntime()
     * @uses PenaltyChargesData::setPenaltyDate2025()
     * @uses PenaltyChargesData::setPenaltyIdDocdate()
     * @uses PenaltyChargesData::setPenaltyIpRisedate()
     * @uses PenaltyChargesData::setPenaltyGisGmp()
     * @uses PenaltyChargesData::setPenaltyPostId()
     * @uses PenaltyChargesData::setOffenderCitizenshipCode()
     * @uses PenaltyChargesData::setPenaltyHoursDaysQty()
     * @uses PenaltyChargesData::setAdmMakeDecisionPostId()
     * @param int $penaltyKey
     * @param string $ospCode
     * @param string $unloadDate
     * @param string $perpetratorType
     * @param string $perpetratorName
     * @param string $perpetratorBirthDate
     * @param string $perpetratorBirthplace
     * @param string $perpetratorSerDoc
     * @param string $perpetratorNumDoc
     * @param string $perpetratorSNILS
     * @param string $perpetratorINN
     * @param string $perpetratorKPP
     * @param string $perpetratorOGRN
     * @param string $perpetratorAdr
     * @param string $perpetratorWorkplace
     * @param string $perpetratorWorkplaceINN
     * @param string $perpetratorWorkplaceTelephone
     * @param string $perpetratorWorkplaceAddress
     * @param string $penaltyNumber
     * @param string $penaltyDate
     * @param string $penaltyRiseDate
     * @param string $iPBasic
     * @param string $penaltyBasic
     * @param string $penaltyIP
     * @param float $penaltySum
     * @param float $penaltyRestTotal
     * @param string $penaltyKbk
     * @param string $penaltyAuthorName
     * @param string $penaltyAuthorTel
     * @param bool $isConfidential
     * @param string $penaltyAdmRisepristName
     * @param int $penaltyIdArtkoap
     * @param string $penaltyUinCode
     * @param string $penaltyUip
     * @param string $penaltyEssentialElements
     * @param string $penaltyExaminationSendDate
     * @param string $penaltyCourtName2
     * @param string $penaltyExaminationResultCode
     * @param string $penaltyCourtAdmCancelDate
     * @param string $penaltyPayDate
     * @param bool $penaltyNoPayIntime
     * @param string $penaltyDate2025
     * @param string $penaltyIdDocdate
     * @param string $penaltyIpRisedate
     * @param bool $penaltyGisGmp
     * @param int $penaltyPostId
     * @param string $offenderCitizenshipCode
     * @param int $penaltyHoursDaysQty
     * @param int $admMakeDecisionPostId
     */
    public function __construct($penaltyKey = null, $ospCode = null, $unloadDate = null, $perpetratorType = null, $perpetratorName = null, $perpetratorBirthDate = null, $perpetratorBirthplace = null, $perpetratorSerDoc = null, $perpetratorNumDoc = null, $perpetratorSNILS = null, $perpetratorINN = null, $perpetratorKPP = null, $perpetratorOGRN = null, $perpetratorAdr = null, $perpetratorWorkplace = null, $perpetratorWorkplaceINN = null, $perpetratorWorkplaceTelephone = null, $perpetratorWorkplaceAddress = null, $penaltyNumber = null, $penaltyDate = null, $penaltyRiseDate = null, $iPBasic = null, $penaltyBasic = null, $penaltyIP = null, $penaltySum = null, $penaltyRestTotal = null, $penaltyKbk = null, $penaltyAuthorName = null, $penaltyAuthorTel = null, $isConfidential = null, $penaltyAdmRisepristName = null, $penaltyIdArtkoap = null, $penaltyUinCode = null, $penaltyUip = null, $penaltyEssentialElements = null, $penaltyExaminationSendDate = null, $penaltyCourtName2 = null, $penaltyExaminationResultCode = null, $penaltyCourtAdmCancelDate = null, $penaltyPayDate = null, $penaltyNoPayIntime = null, $penaltyDate2025 = null, $penaltyIdDocdate = null, $penaltyIpRisedate = null, $penaltyGisGmp = null, $penaltyPostId = null, $offenderCitizenshipCode = null, $penaltyHoursDaysQty = null, $admMakeDecisionPostId = null)
    {
        $this
            ->setPenaltyKey($penaltyKey)
            ->setOspCode($ospCode)
            ->setUnloadDate($unloadDate)
            ->setPerpetratorType($perpetratorType)
            ->setPerpetratorName($perpetratorName)
            ->setPerpetratorBirthDate($perpetratorBirthDate)
            ->setPerpetratorBirthplace($perpetratorBirthplace)
            ->setPerpetratorSerDoc($perpetratorSerDoc)
            ->setPerpetratorNumDoc($perpetratorNumDoc)
            ->setPerpetratorSNILS($perpetratorSNILS)
            ->setPerpetratorINN($perpetratorINN)
            ->setPerpetratorKPP($perpetratorKPP)
            ->setPerpetratorOGRN($perpetratorOGRN)
            ->setPerpetratorAdr($perpetratorAdr)
            ->setPerpetratorWorkplace($perpetratorWorkplace)
            ->setPerpetratorWorkplaceINN($perpetratorWorkplaceINN)
            ->setPerpetratorWorkplaceTelephone($perpetratorWorkplaceTelephone)
            ->setPerpetratorWorkplaceAddress($perpetratorWorkplaceAddress)
            ->setPenaltyNumber($penaltyNumber)
            ->setPenaltyDate($penaltyDate)
            ->setPenaltyRiseDate($penaltyRiseDate)
            ->setIPBasic($iPBasic)
            ->setPenaltyBasic($penaltyBasic)
            ->setPenaltyIP($penaltyIP)
            ->setPenaltySum($penaltySum)
            ->setPenaltyRestTotal($penaltyRestTotal)
            ->setPenaltyKbk($penaltyKbk)
            ->setPenaltyAuthorName($penaltyAuthorName)
            ->setPenaltyAuthorTel($penaltyAuthorTel)
            ->setIsConfidential($isConfidential)
            ->setPenaltyAdmRisepristName($penaltyAdmRisepristName)
            ->setPenaltyIdArtkoap($penaltyIdArtkoap)
            ->setPenaltyUinCode($penaltyUinCode)
            ->setPenaltyUip($penaltyUip)
            ->setPenaltyEssentialElements($penaltyEssentialElements)
            ->setPenaltyExaminationSendDate($penaltyExaminationSendDate)
            ->setPenaltyCourtName2($penaltyCourtName2)
            ->setPenaltyExaminationResultCode($penaltyExaminationResultCode)
            ->setPenaltyCourtAdmCancelDate($penaltyCourtAdmCancelDate)
            ->setPenaltyPayDate($penaltyPayDate)
            ->setPenaltyNoPayIntime($penaltyNoPayIntime)
            ->setPenaltyDate2025($penaltyDate2025)
            ->setPenaltyIdDocdate($penaltyIdDocdate)
            ->setPenaltyIpRisedate($penaltyIpRisedate)
            ->setPenaltyGisGmp($penaltyGisGmp)
            ->setPenaltyPostId($penaltyPostId)
            ->setOffenderCitizenshipCode($offenderCitizenshipCode)
            ->setPenaltyHoursDaysQty($penaltyHoursDaysQty)
            ->setAdmMakeDecisionPostId($admMakeDecisionPostId);
    }
    /**
     * Get PenaltyKey value
     * @return int|null
     */
    public function getPenaltyKey()
    {
        return $this->PenaltyKey;
    }
    /**
     * Set PenaltyKey value
     * @param int $penaltyKey
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyKey($penaltyKey = null)
    {
        $this->PenaltyKey = $penaltyKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \StructType\PenaltyChargesData
     */
    public function setOspCode($ospCode = null)
    {
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \StructType\PenaltyChargesData
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get PerpetratorType value
     * @return string|null
     */
    public function getPerpetratorType()
    {
        return $this->PerpetratorType;
    }
    /**
     * Set PerpetratorType value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $perpetratorType
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorType($perpetratorType = null)
    {
        $this->PerpetratorType = $perpetratorType;
        return $this;
    }
    /**
     * Get PerpetratorName value
     * @return string|null
     */
    public function getPerpetratorName()
    {
        return $this->PerpetratorName;
    }
    /**
     * Set PerpetratorName value
     * @param string $perpetratorName
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorName($perpetratorName = null)
    {
        $this->PerpetratorName = $perpetratorName;
        return $this;
    }
    /**
     * Get PerpetratorBirthDate value
     * @return string|null
     */
    public function getPerpetratorBirthDate()
    {
        return $this->PerpetratorBirthDate;
    }
    /**
     * Set PerpetratorBirthDate value
     * @param string $perpetratorBirthDate
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorBirthDate($perpetratorBirthDate = null)
    {
        $this->PerpetratorBirthDate = $perpetratorBirthDate;
        return $this;
    }
    /**
     * Get PerpetratorBirthplace value
     * @return string|null
     */
    public function getPerpetratorBirthplace()
    {
        return $this->PerpetratorBirthplace;
    }
    /**
     * Set PerpetratorBirthplace value
     * @param string $perpetratorBirthplace
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorBirthplace($perpetratorBirthplace = null)
    {
        $this->PerpetratorBirthplace = $perpetratorBirthplace;
        return $this;
    }
    /**
     * Get PerpetratorSerDoc value
     * @return string|null
     */
    public function getPerpetratorSerDoc()
    {
        return $this->PerpetratorSerDoc;
    }
    /**
     * Set PerpetratorSerDoc value
     * @param string $perpetratorSerDoc
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorSerDoc($perpetratorSerDoc = null)
    {
        $this->PerpetratorSerDoc = $perpetratorSerDoc;
        return $this;
    }
    /**
     * Get PerpetratorNumDoc value
     * @return string|null
     */
    public function getPerpetratorNumDoc()
    {
        return $this->PerpetratorNumDoc;
    }
    /**
     * Set PerpetratorNumDoc value
     * @param string $perpetratorNumDoc
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorNumDoc($perpetratorNumDoc = null)
    {
        $this->PerpetratorNumDoc = $perpetratorNumDoc;
        return $this;
    }
    /**
     * Get PerpetratorSNILS value
     * @return string|null
     */
    public function getPerpetratorSNILS()
    {
        return $this->PerpetratorSNILS;
    }
    /**
     * Set PerpetratorSNILS value
     * @param string $perpetratorSNILS
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorSNILS($perpetratorSNILS = null)
    {
        $this->PerpetratorSNILS = $perpetratorSNILS;
        return $this;
    }
    /**
     * Get PerpetratorINN value
     * @return string|null
     */
    public function getPerpetratorINN()
    {
        return $this->PerpetratorINN;
    }
    /**
     * Set PerpetratorINN value
     * @param string $perpetratorINN
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorINN($perpetratorINN = null)
    {
        $this->PerpetratorINN = $perpetratorINN;
        return $this;
    }
    /**
     * Get PerpetratorKPP value
     * @return string|null
     */
    public function getPerpetratorKPP()
    {
        return $this->PerpetratorKPP;
    }
    /**
     * Set PerpetratorKPP value
     * @param string $perpetratorKPP
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorKPP($perpetratorKPP = null)
    {
        $this->PerpetratorKPP = $perpetratorKPP;
        return $this;
    }
    /**
     * Get PerpetratorOGRN value
     * @return string|null
     */
    public function getPerpetratorOGRN()
    {
        return $this->PerpetratorOGRN;
    }
    /**
     * Set PerpetratorOGRN value
     * @param string $perpetratorOGRN
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorOGRN($perpetratorOGRN = null)
    {
        $this->PerpetratorOGRN = $perpetratorOGRN;
        return $this;
    }
    /**
     * Get PerpetratorAdr value
     * @return string|null
     */
    public function getPerpetratorAdr()
    {
        return $this->PerpetratorAdr;
    }
    /**
     * Set PerpetratorAdr value
     * @param string $perpetratorAdr
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorAdr($perpetratorAdr = null)
    {
        $this->PerpetratorAdr = $perpetratorAdr;
        return $this;
    }
    /**
     * Get PerpetratorWorkplace value
     * @return string|null
     */
    public function getPerpetratorWorkplace()
    {
        return $this->PerpetratorWorkplace;
    }
    /**
     * Set PerpetratorWorkplace value
     * @param string $perpetratorWorkplace
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorWorkplace($perpetratorWorkplace = null)
    {
        $this->PerpetratorWorkplace = $perpetratorWorkplace;
        return $this;
    }
    /**
     * Get PerpetratorWorkplaceINN value
     * @return string|null
     */
    public function getPerpetratorWorkplaceINN()
    {
        return $this->PerpetratorWorkplaceINN;
    }
    /**
     * Set PerpetratorWorkplaceINN value
     * @param string $perpetratorWorkplaceINN
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorWorkplaceINN($perpetratorWorkplaceINN = null)
    {
        $this->PerpetratorWorkplaceINN = $perpetratorWorkplaceINN;
        return $this;
    }
    /**
     * Get PerpetratorWorkplaceTelephone value
     * @return string|null
     */
    public function getPerpetratorWorkplaceTelephone()
    {
        return $this->PerpetratorWorkplaceTelephone;
    }
    /**
     * Set PerpetratorWorkplaceTelephone value
     * @param string $perpetratorWorkplaceTelephone
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorWorkplaceTelephone($perpetratorWorkplaceTelephone = null)
    {
        $this->PerpetratorWorkplaceTelephone = $perpetratorWorkplaceTelephone;
        return $this;
    }
    /**
     * Get PerpetratorWorkplaceAddress value
     * @return string|null
     */
    public function getPerpetratorWorkplaceAddress()
    {
        return $this->PerpetratorWorkplaceAddress;
    }
    /**
     * Set PerpetratorWorkplaceAddress value
     * @param string $perpetratorWorkplaceAddress
     * @return \StructType\PenaltyChargesData
     */
    public function setPerpetratorWorkplaceAddress($perpetratorWorkplaceAddress = null)
    {
        $this->PerpetratorWorkplaceAddress = $perpetratorWorkplaceAddress;
        return $this;
    }
    /**
     * Get PenaltyNumber value
     * @return string|null
     */
    public function getPenaltyNumber()
    {
        return $this->PenaltyNumber;
    }
    /**
     * Set PenaltyNumber value
     * @param string $penaltyNumber
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyNumber($penaltyNumber = null)
    {
        $this->PenaltyNumber = $penaltyNumber;
        return $this;
    }
    /**
     * Get PenaltyDate value
     * @return string|null
     */
    public function getPenaltyDate()
    {
        return $this->PenaltyDate;
    }
    /**
     * Set PenaltyDate value
     * @param string $penaltyDate
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyDate($penaltyDate = null)
    {
        $this->PenaltyDate = $penaltyDate;
        return $this;
    }
    /**
     * Get PenaltyRiseDate value
     * @return string|null
     */
    public function getPenaltyRiseDate()
    {
        return $this->PenaltyRiseDate;
    }
    /**
     * Set PenaltyRiseDate value
     * @param string $penaltyRiseDate
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyRiseDate($penaltyRiseDate = null)
    {
        $this->PenaltyRiseDate = $penaltyRiseDate;
        return $this;
    }
    /**
     * Get IPBasic value
     * @return string|null
     */
    public function getIPBasic()
    {
        return $this->IPBasic;
    }
    /**
     * Set IPBasic value
     * @param string $iPBasic
     * @return \StructType\PenaltyChargesData
     */
    public function setIPBasic($iPBasic = null)
    {
        $this->IPBasic = $iPBasic;
        return $this;
    }
    /**
     * Get PenaltyBasic value
     * @return string|null
     */
    public function getPenaltyBasic()
    {
        return $this->PenaltyBasic;
    }
    /**
     * Set PenaltyBasic value
     * @param string $penaltyBasic
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyBasic($penaltyBasic = null)
    {
        $this->PenaltyBasic = $penaltyBasic;
        return $this;
    }
    /**
     * Get PenaltyIP value
     * @return string|null
     */
    public function getPenaltyIP()
    {
        return $this->PenaltyIP;
    }
    /**
     * Set PenaltyIP value
     * @param string $penaltyIP
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyIP($penaltyIP = null)
    {
        $this->PenaltyIP = $penaltyIP;
        return $this;
    }
    /**
     * Get PenaltySum value
     * @return float|null
     */
    public function getPenaltySum()
    {
        return $this->PenaltySum;
    }
    /**
     * Set PenaltySum value
     * @param float $penaltySum
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltySum($penaltySum = null)
    {
        $this->PenaltySum = $penaltySum;
        return $this;
    }
    /**
     * Get PenaltyRestTotal value
     * @return float|null
     */
    public function getPenaltyRestTotal()
    {
        return $this->PenaltyRestTotal;
    }
    /**
     * Set PenaltyRestTotal value
     * @param float $penaltyRestTotal
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyRestTotal($penaltyRestTotal = null)
    {
        $this->PenaltyRestTotal = $penaltyRestTotal;
        return $this;
    }
    /**
     * Get PenaltyKbk value
     * @return string|null
     */
    public function getPenaltyKbk()
    {
        return $this->PenaltyKbk;
    }
    /**
     * Set PenaltyKbk value
     * @param string $penaltyKbk
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyKbk($penaltyKbk = null)
    {
        $this->PenaltyKbk = $penaltyKbk;
        return $this;
    }
    /**
     * Get PenaltyAuthorName value
     * @return string|null
     */
    public function getPenaltyAuthorName()
    {
        return $this->PenaltyAuthorName;
    }
    /**
     * Set PenaltyAuthorName value
     * @param string $penaltyAuthorName
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyAuthorName($penaltyAuthorName = null)
    {
        $this->PenaltyAuthorName = $penaltyAuthorName;
        return $this;
    }
    /**
     * Get PenaltyAuthorTel value
     * @return string|null
     */
    public function getPenaltyAuthorTel()
    {
        return $this->PenaltyAuthorTel;
    }
    /**
     * Set PenaltyAuthorTel value
     * @param string $penaltyAuthorTel
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyAuthorTel($penaltyAuthorTel = null)
    {
        $this->PenaltyAuthorTel = $penaltyAuthorTel;
        return $this;
    }
    /**
     * Get IsConfidential value
     * @return bool|null
     */
    public function getIsConfidential()
    {
        return $this->IsConfidential;
    }
    /**
     * Set IsConfidential value
     * @param bool $isConfidential
     * @return \StructType\PenaltyChargesData
     */
    public function setIsConfidential($isConfidential = null)
    {
        $this->IsConfidential = $isConfidential;
        return $this;
    }
    /**
     * Get PenaltyAdmRisepristName value
     * @return string|null
     */
    public function getPenaltyAdmRisepristName()
    {
        return $this->PenaltyAdmRisepristName;
    }
    /**
     * Set PenaltyAdmRisepristName value
     * @param string $penaltyAdmRisepristName
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyAdmRisepristName($penaltyAdmRisepristName = null)
    {
        $this->PenaltyAdmRisepristName = $penaltyAdmRisepristName;
        return $this;
    }
    /**
     * Get PenaltyIdArtkoap value
     * @return int|null
     */
    public function getPenaltyIdArtkoap()
    {
        return $this->PenaltyIdArtkoap;
    }
    /**
     * Set PenaltyIdArtkoap value
     * @param int $penaltyIdArtkoap
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyIdArtkoap($penaltyIdArtkoap = null)
    {
        $this->PenaltyIdArtkoap = $penaltyIdArtkoap;
        return $this;
    }
    /**
     * Get PenaltyUinCode value
     * @return string|null
     */
    public function getPenaltyUinCode()
    {
        return $this->PenaltyUinCode;
    }
    /**
     * Set PenaltyUinCode value
     * @param string $penaltyUinCode
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyUinCode($penaltyUinCode = null)
    {
        $this->PenaltyUinCode = $penaltyUinCode;
        return $this;
    }
    /**
     * Get PenaltyUip value
     * @return string|null
     */
    public function getPenaltyUip()
    {
        return $this->PenaltyUip;
    }
    /**
     * Set PenaltyUip value
     * @param string $penaltyUip
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyUip($penaltyUip = null)
    {
        $this->PenaltyUip = $penaltyUip;
        return $this;
    }
    /**
     * Get PenaltyEssentialElements value
     * @return string|null
     */
    public function getPenaltyEssentialElements()
    {
        return $this->PenaltyEssentialElements;
    }
    /**
     * Set PenaltyEssentialElements value
     * @param string $penaltyEssentialElements
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyEssentialElements($penaltyEssentialElements = null)
    {
        $this->PenaltyEssentialElements = $penaltyEssentialElements;
        return $this;
    }
    /**
     * Get PenaltyExaminationSendDate value
     * @return string|null
     */
    public function getPenaltyExaminationSendDate()
    {
        return $this->PenaltyExaminationSendDate;
    }
    /**
     * Set PenaltyExaminationSendDate value
     * @param string $penaltyExaminationSendDate
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyExaminationSendDate($penaltyExaminationSendDate = null)
    {
        $this->PenaltyExaminationSendDate = $penaltyExaminationSendDate;
        return $this;
    }
    /**
     * Get PenaltyCourtName2 value
     * @return string|null
     */
    public function getPenaltyCourtName2()
    {
        return $this->PenaltyCourtName2;
    }
    /**
     * Set PenaltyCourtName2 value
     * @param string $penaltyCourtName2
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyCourtName2($penaltyCourtName2 = null)
    {
        $this->PenaltyCourtName2 = $penaltyCourtName2;
        return $this;
    }
    /**
     * Get PenaltyExaminationResultCode value
     * @return string|null
     */
    public function getPenaltyExaminationResultCode()
    {
        return $this->PenaltyExaminationResultCode;
    }
    /**
     * Set PenaltyExaminationResultCode value
     * @param string $penaltyExaminationResultCode
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyExaminationResultCode($penaltyExaminationResultCode = null)
    {
        $this->PenaltyExaminationResultCode = $penaltyExaminationResultCode;
        return $this;
    }
    /**
     * Get PenaltyCourtAdmCancelDate value
     * @return string|null
     */
    public function getPenaltyCourtAdmCancelDate()
    {
        return $this->PenaltyCourtAdmCancelDate;
    }
    /**
     * Set PenaltyCourtAdmCancelDate value
     * @param string $penaltyCourtAdmCancelDate
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyCourtAdmCancelDate($penaltyCourtAdmCancelDate = null)
    {
        $this->PenaltyCourtAdmCancelDate = $penaltyCourtAdmCancelDate;
        return $this;
    }
    /**
     * Get PenaltyPayDate value
     * @return string|null
     */
    public function getPenaltyPayDate()
    {
        return $this->PenaltyPayDate;
    }
    /**
     * Set PenaltyPayDate value
     * @param string $penaltyPayDate
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyPayDate($penaltyPayDate = null)
    {
        $this->PenaltyPayDate = $penaltyPayDate;
        return $this;
    }
    /**
     * Get PenaltyNoPayIntime value
     * @return bool|null
     */
    public function getPenaltyNoPayIntime()
    {
        return $this->PenaltyNoPayIntime;
    }
    /**
     * Set PenaltyNoPayIntime value
     * @param bool $penaltyNoPayIntime
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyNoPayIntime($penaltyNoPayIntime = null)
    {
        $this->PenaltyNoPayIntime = $penaltyNoPayIntime;
        return $this;
    }
    /**
     * Get PenaltyDate2025 value
     * @return string|null
     */
    public function getPenaltyDate2025()
    {
        return $this->PenaltyDate2025;
    }
    /**
     * Set PenaltyDate2025 value
     * @param string $penaltyDate2025
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyDate2025($penaltyDate2025 = null)
    {
        $this->PenaltyDate2025 = $penaltyDate2025;
        return $this;
    }
    /**
     * Get PenaltyIdDocdate value
     * @return string|null
     */
    public function getPenaltyIdDocdate()
    {
        return $this->PenaltyIdDocdate;
    }
    /**
     * Set PenaltyIdDocdate value
     * @param string $penaltyIdDocdate
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyIdDocdate($penaltyIdDocdate = null)
    {
        $this->PenaltyIdDocdate = $penaltyIdDocdate;
        return $this;
    }
    /**
     * Get PenaltyIpRisedate value
     * @return string|null
     */
    public function getPenaltyIpRisedate()
    {
        return $this->PenaltyIpRisedate;
    }
    /**
     * Set PenaltyIpRisedate value
     * @param string $penaltyIpRisedate
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyIpRisedate($penaltyIpRisedate = null)
    {
        $this->PenaltyIpRisedate = $penaltyIpRisedate;
        return $this;
    }
    /**
     * Get PenaltyGisGmp value
     * @return bool|null
     */
    public function getPenaltyGisGmp()
    {
        return $this->PenaltyGisGmp;
    }
    /**
     * Set PenaltyGisGmp value
     * @param bool $penaltyGisGmp
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyGisGmp($penaltyGisGmp = null)
    {
        $this->PenaltyGisGmp = $penaltyGisGmp;
        return $this;
    }
    /**
     * Get PenaltyPostId value
     * @return int|null
     */
    public function getPenaltyPostId()
    {
        return $this->PenaltyPostId;
    }
    /**
     * Set PenaltyPostId value
     * @param int $penaltyPostId
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyPostId($penaltyPostId = null)
    {
        $this->PenaltyPostId = $penaltyPostId;
        return $this;
    }
    /**
     * Get OffenderCitizenshipCode value
     * @return string|null
     */
    public function getOffenderCitizenshipCode()
    {
        return $this->OffenderCitizenshipCode;
    }
    /**
     * Set OffenderCitizenshipCode value
     * @param string $offenderCitizenshipCode
     * @return \StructType\PenaltyChargesData
     */
    public function setOffenderCitizenshipCode($offenderCitizenshipCode = null)
    {
        $this->OffenderCitizenshipCode = $offenderCitizenshipCode;
        return $this;
    }
    /**
     * Get PenaltyHoursDaysQty value
     * @return int|null
     */
    public function getPenaltyHoursDaysQty()
    {
        return $this->PenaltyHoursDaysQty;
    }
    /**
     * Set PenaltyHoursDaysQty value
     * @param int $penaltyHoursDaysQty
     * @return \StructType\PenaltyChargesData
     */
    public function setPenaltyHoursDaysQty($penaltyHoursDaysQty = null)
    {
        $this->PenaltyHoursDaysQty = $penaltyHoursDaysQty;
        return $this;
    }
    /**
     * Get AdmMakeDecisionPostId value
     * @return int|null
     */
    public function getAdmMakeDecisionPostId()
    {
        return $this->AdmMakeDecisionPostId;
    }
    /**
     * Set AdmMakeDecisionPostId value
     * @param int $admMakeDecisionPostId
     * @return \StructType\PenaltyChargesData
     */
    public function setAdmMakeDecisionPostId($admMakeDecisionPostId = null)
    {
        $this->AdmMakeDecisionPostId = $admMakeDecisionPostId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PenaltyChargesData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
