<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProperties StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер PaymentProperties «Реквизиты для перечисления» | Реквизиты для перечисления взысканных сумм взыскателю (для налоговых
 * платежей может быть указано более одного набора реквизитов)
 * - type: tns:PaymentProperties
 * @subpackage Structs
 */
class PaymentProperties extends AbstractStructBase
{
    /**
     * The RecpName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование получателя | Наименование получателя (взыскателя) для указания в платежном документе | Строка длиной от 1 до 160
     * символов
     * - maxLength: 160
     * - minLength: 1
     * @var string
     */
    public $RecpName;
    /**
     * The RecpBank
     * Meta informations extracted from the WSDL
     * - documentation: Банк получателя (взыскателя) | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $RecpBank;
    /**
     * The RecpBIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК банка получателя (взыскателя) | Банковский идентификационный код (БИК)
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $RecpBIK;
    /**
     * The RecpCnt
     * Meta informations extracted from the WSDL
     * - documentation: Расчетный счет получателя (взыскателя) | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $RecpCnt;
    /**
     * The RecpINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН получателя (взыскателя) | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $RecpINN;
    /**
     * The RecpKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП получателя (взыскателя) | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $RecpKPP;
    /**
     * The Okato
     * Meta informations extracted from the WSDL
     * - documentation: ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $Okato;
    /**
     * The Oktmo
     * Meta informations extracted from the WSDL
     * - documentation: ОКТМО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $Oktmo;
    /**
     * The Kbk
     * Meta informations extracted from the WSDL
     * - documentation: КБК | Код бюджетной классификации (КБК)
     * - minOccurs: 0
     * - length: 20
     * - pattern: [0-9]{20}
     * @var string
     */
    public $Kbk;
    /**
     * The PersonalAccount
     * Meta informations extracted from the WSDL
     * - documentation: Лицевой счет | Лицевой счет
     * - minOccurs: 0
     * - length: 11
     * @var string
     */
    public $PersonalAccount;
    /**
     * The UNIFOCode
     * Meta informations extracted from the WSDL
     * - documentation: Код начисления УНИФО | Заполняется в том случае, если данная сумма зарегистрирована как начисление в системе УНИФО | Код
     * начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $UNIFOCode;
    /**
     * The PokPl
     * Meta informations extracted from the WSDL
     * - documentation: Показатель типа платежа | В соответствии с приказом Минфина №107н от 12.11.2013 | Показатель типа платежа | ATTR_PAYMENT_TYPE (Приказ Минфина
     * №107н от 12.11.2013)
     * - minOccurs: 0
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $PokPl;
    /**
     * The RekvSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма, перечисляемая по данным реквизитам | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RekvSum;
    /**
     * Constructor method for PaymentProperties
     * @uses PaymentProperties::setRecpName()
     * @uses PaymentProperties::setRecpBank()
     * @uses PaymentProperties::setRecpBIK()
     * @uses PaymentProperties::setRecpCnt()
     * @uses PaymentProperties::setRecpINN()
     * @uses PaymentProperties::setRecpKPP()
     * @uses PaymentProperties::setOkato()
     * @uses PaymentProperties::setOktmo()
     * @uses PaymentProperties::setKbk()
     * @uses PaymentProperties::setPersonalAccount()
     * @uses PaymentProperties::setUNIFOCode()
     * @uses PaymentProperties::setPokPl()
     * @uses PaymentProperties::setRekvSum()
     * @param string $recpName
     * @param string $recpBank
     * @param string $recpBIK
     * @param string $recpCnt
     * @param string $recpINN
     * @param string $recpKPP
     * @param string $okato
     * @param string $oktmo
     * @param string $kbk
     * @param string $personalAccount
     * @param string $uNIFOCode
     * @param string $pokPl
     * @param float $rekvSum
     */
    public function __construct($recpName = null, $recpBank = null, $recpBIK = null, $recpCnt = null, $recpINN = null, $recpKPP = null, $okato = null, $oktmo = null, $kbk = null, $personalAccount = null, $uNIFOCode = null, $pokPl = null, $rekvSum = null)
    {
        $this
            ->setRecpName($recpName)
            ->setRecpBank($recpBank)
            ->setRecpBIK($recpBIK)
            ->setRecpCnt($recpCnt)
            ->setRecpINN($recpINN)
            ->setRecpKPP($recpKPP)
            ->setOkato($okato)
            ->setOktmo($oktmo)
            ->setKbk($kbk)
            ->setPersonalAccount($personalAccount)
            ->setUNIFOCode($uNIFOCode)
            ->setPokPl($pokPl)
            ->setRekvSum($rekvSum);
    }
    /**
     * Get RecpName value
     * @return string|null
     */
    public function getRecpName()
    {
        return $this->RecpName;
    }
    /**
     * Set RecpName value
     * @param string $recpName
     * @return \StructType\PaymentProperties
     */
    public function setRecpName($recpName = null)
    {
        $this->RecpName = $recpName;
        return $this;
    }
    /**
     * Get RecpBank value
     * @return string|null
     */
    public function getRecpBank()
    {
        return $this->RecpBank;
    }
    /**
     * Set RecpBank value
     * @param string $recpBank
     * @return \StructType\PaymentProperties
     */
    public function setRecpBank($recpBank = null)
    {
        $this->RecpBank = $recpBank;
        return $this;
    }
    /**
     * Get RecpBIK value
     * @return string|null
     */
    public function getRecpBIK()
    {
        return $this->RecpBIK;
    }
    /**
     * Set RecpBIK value
     * @param string $recpBIK
     * @return \StructType\PaymentProperties
     */
    public function setRecpBIK($recpBIK = null)
    {
        $this->RecpBIK = $recpBIK;
        return $this;
    }
    /**
     * Get RecpCnt value
     * @return string|null
     */
    public function getRecpCnt()
    {
        return $this->RecpCnt;
    }
    /**
     * Set RecpCnt value
     * @param string $recpCnt
     * @return \StructType\PaymentProperties
     */
    public function setRecpCnt($recpCnt = null)
    {
        $this->RecpCnt = $recpCnt;
        return $this;
    }
    /**
     * Get RecpINN value
     * @return string|null
     */
    public function getRecpINN()
    {
        return $this->RecpINN;
    }
    /**
     * Set RecpINN value
     * @param string $recpINN
     * @return \StructType\PaymentProperties
     */
    public function setRecpINN($recpINN = null)
    {
        $this->RecpINN = $recpINN;
        return $this;
    }
    /**
     * Get RecpKPP value
     * @return string|null
     */
    public function getRecpKPP()
    {
        return $this->RecpKPP;
    }
    /**
     * Set RecpKPP value
     * @param string $recpKPP
     * @return \StructType\PaymentProperties
     */
    public function setRecpKPP($recpKPP = null)
    {
        $this->RecpKPP = $recpKPP;
        return $this;
    }
    /**
     * Get Okato value
     * @return string|null
     */
    public function getOkato()
    {
        return $this->Okato;
    }
    /**
     * Set Okato value
     * @param string $okato
     * @return \StructType\PaymentProperties
     */
    public function setOkato($okato = null)
    {
        $this->Okato = $okato;
        return $this;
    }
    /**
     * Get Oktmo value
     * @return string|null
     */
    public function getOktmo()
    {
        return $this->Oktmo;
    }
    /**
     * Set Oktmo value
     * @param string $oktmo
     * @return \StructType\PaymentProperties
     */
    public function setOktmo($oktmo = null)
    {
        $this->Oktmo = $oktmo;
        return $this;
    }
    /**
     * Get Kbk value
     * @return string|null
     */
    public function getKbk()
    {
        return $this->Kbk;
    }
    /**
     * Set Kbk value
     * @param string $kbk
     * @return \StructType\PaymentProperties
     */
    public function setKbk($kbk = null)
    {
        $this->Kbk = $kbk;
        return $this;
    }
    /**
     * Get PersonalAccount value
     * @return string|null
     */
    public function getPersonalAccount()
    {
        return $this->PersonalAccount;
    }
    /**
     * Set PersonalAccount value
     * @param string $personalAccount
     * @return \StructType\PaymentProperties
     */
    public function setPersonalAccount($personalAccount = null)
    {
        $this->PersonalAccount = $personalAccount;
        return $this;
    }
    /**
     * Get UNIFOCode value
     * @return string|null
     */
    public function getUNIFOCode()
    {
        return $this->UNIFOCode;
    }
    /**
     * Set UNIFOCode value
     * @param string $uNIFOCode
     * @return \StructType\PaymentProperties
     */
    public function setUNIFOCode($uNIFOCode = null)
    {
        $this->UNIFOCode = $uNIFOCode;
        return $this;
    }
    /**
     * Get PokPl value
     * @return string|null
     */
    public function getPokPl()
    {
        return $this->PokPl;
    }
    /**
     * Set PokPl value
     * @param string $pokPl
     * @return \StructType\PaymentProperties
     */
    public function setPokPl($pokPl = null)
    {
        $this->PokPl = $pokPl;
        return $this;
    }
    /**
     * Get RekvSum value
     * @return float|null
     */
    public function getRekvSum()
    {
        return $this->RekvSum;
    }
    /**
     * Set RekvSum value
     * @param float $rekvSum
     * @return \StructType\PaymentProperties
     */
    public function setRekvSum($rekvSum = null)
    {
        $this->RekvSum = $rekvSum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentProperties
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
