<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentNotification StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ PaymentNotification «Уведомление о платеже»
 * - type: tns:PaymentNotification
 * @subpackage Structs
 */
class PaymentNotification extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The BillNumber
     * Meta informations extracted from the WSDL
     * - documentation: УИН начисления | Код начисления УНИФО
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $BillNumber;
    /**
     * The PaymentId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор транзакции | Строка длиной от 1 до 12 символов
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $PaymentId;
    /**
     * The PaymentStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус платежа | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $PaymentStatus;
    /**
     * The IsPayed
     * Meta informations extracted from the WSDL
     * - documentation: Признак успешной оплаты платежа | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsPayed;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время платежа | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $PaymentDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма платежа | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for PaymentNotification
     * @uses PaymentNotification::setExternalKey()
     * @uses PaymentNotification::setBillNumber()
     * @uses PaymentNotification::setPaymentId()
     * @uses PaymentNotification::setPaymentStatus()
     * @uses PaymentNotification::setIsPayed()
     * @uses PaymentNotification::setPaymentDate()
     * @uses PaymentNotification::setAmount()
     * @param string $externalKey
     * @param string $billNumber
     * @param string $paymentId
     * @param string $paymentStatus
     * @param bool $isPayed
     * @param string $paymentDate
     * @param float $amount
     */
    public function __construct($externalKey = null, $billNumber = null, $paymentId = null, $paymentStatus = null, $isPayed = null, $paymentDate = null, $amount = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setBillNumber($billNumber)
            ->setPaymentId($paymentId)
            ->setPaymentStatus($paymentStatus)
            ->setIsPayed($isPayed)
            ->setPaymentDate($paymentDate)
            ->setAmount($amount);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\PaymentNotification
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get BillNumber value
     * @return string|null
     */
    public function getBillNumber()
    {
        return $this->BillNumber;
    }
    /**
     * Set BillNumber value
     * @param string $billNumber
     * @return \StructType\PaymentNotification
     */
    public function setBillNumber($billNumber = null)
    {
        $this->BillNumber = $billNumber;
        return $this;
    }
    /**
     * Get PaymentId value
     * @return string|null
     */
    public function getPaymentId()
    {
        return $this->PaymentId;
    }
    /**
     * Set PaymentId value
     * @param string $paymentId
     * @return \StructType\PaymentNotification
     */
    public function setPaymentId($paymentId = null)
    {
        $this->PaymentId = $paymentId;
        return $this;
    }
    /**
     * Get PaymentStatus value
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->PaymentStatus;
    }
    /**
     * Set PaymentStatus value
     * @param string $paymentStatus
     * @return \StructType\PaymentNotification
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        $this->PaymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * Get IsPayed value
     * @return bool|null
     */
    public function getIsPayed()
    {
        return $this->IsPayed;
    }
    /**
     * Set IsPayed value
     * @param bool $isPayed
     * @return \StructType\PaymentNotification
     */
    public function setIsPayed($isPayed = null)
    {
        $this->IsPayed = $isPayed;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\PaymentNotification
     */
    public function setPaymentDate($paymentDate = null)
    {
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\PaymentNotification
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
